/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import gnu.trove.TIntArrayList;
import iitb.ugm.CliquePotential;
import iitb.ugm.LogMath;
import iitb.ugm.Potential;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PotentialHelper {
    public static Potential multiply(Vector<Potential> ps, Vector<int[]> variables, int[] card) throws Exception {
        TreeMap<Integer, Integer> res_set = new TreeMap<Integer, Integer>();
        int maxArity = 0;
        int j = 0;
        while (j < ps.size()) {
            int k = 0;
            while (k < variables.get(j).length) {
                int i = variables.get(j)[k];
                res_set.put(i, card[i]);
                if (card[i] > maxArity) {
                    maxArity = card[i];
                }
                ++k;
            }
            ++j;
        }
        if (res_set.size() == 0) {
            throw new Exception("I have 0 variables in result, huh");
        }
        CliquePotential result = new CliquePotential(maxArity, res_set.size(), 0.0);
        TreeMap<Integer, Integer> resultVal = new TreeMap<Integer, Integer>();
        Integer[] toPass = new Integer[res_set.size()];
        res_set.keySet().toArray(toPass);
        PotentialHelper._multiply(0, resultVal, ps, result, variables, card, toPass);
        return result;
    }

    private static void _multiply(int idx, TreeMap<Integer, Integer> resultVal, Vector<Potential> ps, Potential result, Vector<int[]> variables, int[] card, Integer[] resultVars) {
        int n = result.getCliqueSize();
        if (idx >= n) {
            double prod = 0.0;
            int j = 0;
            while (j < ps.size()) {
                Potential p = ps.get(j);
                TIntArrayList pval = new TIntArrayList();
                int i = 0;
                while (i < variables.get(j).length) {
                    int k = variables.get(j)[i];
                    int kval = resultVal.get(k);
                    pval.add(kval);
                    ++i;
                }
                prod += p.getPotential(pval.toNativeArray());
                ++j;
            }
            int[] labels = new int[resultVars.length];
            Arrays.sort((Object[])resultVars);
            int i = 0;
            while (i < resultVars.length) {
                labels[i] = resultVal.get(resultVars[i]);
                ++i;
            }
            result.setPotential(labels, prod);
            return;
        }
        int v = resultVars[idx];
        int csz = card[v];
        int i = 0;
        while (i < csz) {
            resultVal.put(v, i);
            PotentialHelper._multiply(idx + 1, resultVal, ps, result, variables, card, resultVars);
            ++i;
        }
    }

    public static Potential marginalize(Potential potential, Set<Integer> varsToRemove, Set<Integer> allVars, int[] card) throws Exception {
        TIntArrayList varsResult = new TIntArrayList();
        TIntArrayList myvars = new TIntArrayList();
        Integer[] vars = new Integer[allVars.size()];
        allVars.toArray(vars);
        boolean[] inResult = new boolean[allVars.size()];
        int maxArity = 0;
        int i = 0;
        while (i < inResult.length) {
            myvars.add(-1);
            boolean bl = inResult[i] = !varsToRemove.contains(vars[i]);
            if (inResult[i]) {
                varsResult.add(card[i]);
                if (card[i] > maxArity) {
                    maxArity = card[i];
                }
            }
            ++i;
        }
        if (varsResult.size() == 0) {
            throw new Exception("I have 0 variables in result, call getPartitionValue instead");
        }
        CliquePotential p = new CliquePotential(maxArity, varsResult.size(), LogMath.LOG0);
        PotentialHelper._marginalize(potential, p, varsResult, myvars, 0, 0, inResult, vars, card);
        return p;
    }

    private static void _marginalize(Potential potential, Potential p, TIntArrayList varsResult, TIntArrayList myvars, int idx, int resIdx, boolean[] inResult, Integer[] vars, int[] card) {
        if (idx == vars.length) {
            double v = p.getPotential(varsResult.toNativeArray());
            double deltav = potential.getPotential(myvars.toNativeArray());
            p.setPotential(varsResult.toNativeArray(), LogMath.logSumExp(v, deltav));
            return;
        }
        boolean j = false;
        int i = 0;
        while (i < card[idx]) {
            myvars.set(idx, i);
            if (inResult[idx]) {
                varsResult.set(resIdx++, i);
            }
            PotentialHelper._marginalize(potential, p, varsResult, myvars, idx + 1, resIdx, inResult, vars, card);
            ++i;
        }
    }
}

