/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import gnu.trove.TIntArrayList;
import iitb.ugm.CliquePotential;
import iitb.ugm.GraphicalModel;
import iitb.ugm.PairwiseConstraint;
import iitb.ugm.PairwiseConstraints;
import iitb.ugm.PairwisePotential;
import iitb.ugm.Potential;
import iitb.ugm.UDGM;
import iitb.ugm.UDGraph;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PairwiseModel
extends UDGM {
    private int[] nodes = new int[2];
    private int[] labels = new int[2];

    public PairwiseModel(Potential defaultEdgePotential, int numOfNodes, int nodeArity, int cliqueSize) {
        super(defaultEdgePotential, numOfNodes, nodeArity, cliqueSize);
    }

    public PairwiseModel(UDGraph graph, int uniformArity, Potential defaultEdgePotential) {
        super(defaultEdgePotential, graph.getNumNodes(), uniformArity, 2);
        this.graph = graph;
    }

    public PairwiseModel(UDGraph graph, int[] arity, Potential defaultEdgePotential) {
        super(graph, arity, defaultEdgePotential, 2);
    }

    public PairwiseModel(int numNodes) {
        this(null, numNodes, 0, 2);
    }

    public PairwiseModel(int numNodes, int uniformArity) {
        super(null, numNodes, uniformArity, 2);
    }

    public double getEdgePotential(int node1, int label1, int node2, int label2) {
        this.initializeParameters(node1, label1, node2, label2);
        Integer key = this.getCliqueKey(this.nodes);
        if (this.cliquePotentials.containsKey(key)) {
            return ((Potential)this.cliquePotentials.get(key)).getPotential(this.labels);
        }
        return this.defaultCliquePotential.getPotential(this.labels);
    }

    public Potential getEdgePotentialTable(int node1, int node2) {
        Integer key;
        Potential toReturn;
        this.nodes[0] = node1;
        this.nodes[1] = node2;
        if (node1 > node2) {
            this.nodes[0] = node2;
            this.nodes[1] = node1;
        }
        return (toReturn = (Potential)this.cliquePotentials.get(key = this.getCliqueKey(this.nodes))) == null ? this.defaultCliquePotential : toReturn;
    }

    public void setEdgePotential(int node1, int label1, int node2, int label2, double potentialValue) {
        this.initializeParameters(node1, label1, node2, label2);
        Integer key = this.getCliqueKey(this.nodes);
        Potential cliquePotential = (Potential)this.cliquePotentials.get(key);
        if (cliquePotential == null) {
            cliquePotential = new CliquePotential(this.nodeArities[this.nodes[0]], this.nodes.length);
        }
        cliquePotential.setPotential(this.labels, potentialValue);
        this.cliquePotentials.put(key, cliquePotential);
    }

    protected void initializeParameters(int node1, int label1, int node2, int label2) {
        if (node1 < node2) {
            this.nodes[0] = node1;
            this.nodes[1] = node2;
            this.labels[0] = label1;
            this.labels[1] = label2;
        } else {
            this.nodes[0] = node2;
            this.nodes[1] = node1;
            this.labels[0] = label2;
            this.labels[1] = label1;
        }
    }

    public double getScore(int[] labeling) {
        double score = 0.0;
        int i = 0;
        while (i < this.numOfNodes) {
            score += this.getNodePotential(i, labeling[i]);
            ++i;
        }
        i = 0;
        while (i < this.numOfNodes) {
            TIntArrayList nbrs = this.graph.getNeighbours(i);
            int j = 0;
            while (j < nbrs.size()) {
                int nbr = nbrs.get(j);
                if (nbr > i) {
                    score += this.getEdgePotential(i, labeling[i], nbr, labeling[nbr]);
                }
                ++j;
            }
            ++i;
        }
        return score;
    }

    public static GraphicalModel load(String fileUrl, boolean isHomogeneous) {
        try {
            int k;
            int j;
            int i;
            int defaultArity = 0;
            boolean maxArity = false;
            int typesEdges = 0;
            int uniformArity = 0;
            BufferedReader in = new BufferedReader(new FileReader(fileUrl));
            int numNodes = Integer.parseInt(in.readLine());
            if (isHomogeneous) {
                defaultArity = uniformArity = Integer.parseInt(in.readLine());
                typesEdges = Integer.parseInt(in.readLine());
            }
            int numEdges = Integer.parseInt(in.readLine());
            PairwiseModel model = isHomogeneous ? new PairwiseModel(numNodes, uniformArity) : new PairwiseModel(numNodes);
            int i2 = 0;
            while (i2 < numNodes) {
                StringTokenizer tok = new StringTokenizer(in.readLine(), " ");
                int v = Integer.parseInt(tok.nextToken());
                int arity = defaultArity;
                if (!isHomogeneous) {
                    arity = Integer.parseInt(tok.nextToken());
                    if (i2 == 0 && arity > model.getMaxArity()) {
                        model.setMaxArity(arity);
                    }
                    model.setNodeArity(v, arity);
                }
                int j2 = 0;
                while (j2 < arity) {
                    model.setNodePotential(v, j2, Double.parseDouble(tok.nextToken()));
                    ++j2;
                }
                ++i2;
            }
            Hashtable<String, PairwisePotential> edgePotentials = new Hashtable<String, PairwisePotential>();
            if (isHomogeneous) {
                edgePotentials = new Hashtable();
                i = 0;
                while (i < typesEdges) {
                    StringTokenizer tok = new StringTokenizer(in.readLine(), " ");
                    String edgeName = tok.nextToken();
                    PairwisePotential edgePotential = new PairwisePotential(uniformArity);
                    int[] labels = new int[2];
                    j = 0;
                    while (j < uniformArity) {
                        k = 0;
                        while (k < uniformArity) {
                            labels[0] = j;
                            labels[1] = k++;
                            edgePotential.setPotential(labels, Double.parseDouble(tok.nextToken()));
                        }
                        ++j;
                    }
                    edgePotentials.put(edgeName, edgePotential);
                    ++i;
                }
            } else {
                i = 0;
                while (i < numEdges) {
                    StringTokenizer tok = new StringTokenizer(in.readLine(), " ");
                    int head = Integer.parseInt(tok.nextToken());
                    int tail = Integer.parseInt(tok.nextToken());
                    model.getGraph().addEdge(head, tail);
                    int[] nodes = new int[]{head, tail};
                    j = 0;
                    while (j < model.getNodeArity(head)) {
                        k = 0;
                        while (k < model.getNodeArity(tail)) {
                            int[] vals = new int[]{j, k++};
                            model.setCliquePotential(nodes, vals, Double.parseDouble(tok.nextToken()));
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (isHomogeneous) {
                int[] nodes = new int[2];
                PairwiseConstraints cs = null;
                int i3 = 0;
                while (i3 < numEdges) {
                    StringTokenizer tok = new StringTokenizer(in.readLine(), " ");
                    int tail = Integer.parseInt(tok.nextToken());
                    int head = Integer.parseInt(tok.nextToken());
                    nodes[0] = tail;
                    nodes[1] = head;
                    String edgeName = tok.nextToken();
                    PairwisePotential tmp = (PairwisePotential)edgePotentials.get(edgeName);
                    if (tmp == null) {
                        throw new Exception("No edge potential is defined for specified type");
                    }
                    if (edgeName.equalsIgnoreCase("0")) {
                        if (cs == null) {
                            cs = new PairwiseConstraints();
                        }
                        cs.addConstraint(new PairwiseConstraint(tail, head, tmp));
                    } else {
                        model.getGraph().addEdge(head, tail);
                        model.setCliquePotentialTable(nodes, tmp);
                    }
                    ++i3;
                }
                if (cs != null) {
                    model.setConstraints(cs);
                }
            }
            in.close();
            return model;
        }
        catch (IOException io) {
            System.err.println("ioexception " + io);
            io.printStackTrace(System.err);
            return null;
        }
        catch (Exception e) {
            System.err.println("Exception" + e);
            e.printStackTrace();
            return null;
        }
    }
}

