/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import iitb.ugm.SpecialGraph;

public class GridGraph
extends SpecialGraph {
    int gridsz;

    public GridGraph(int numNodes) {
        super(numNodes);
        this.gridsz = (int)Math.sqrt(numNodes);
        assert (this.gridsz * this.gridsz == numNodes);
    }

    public int getNeighbour(int node, int nbrNum) {
        int rowid = node / this.gridsz;
        int colid = node % this.gridsz;
        return -1;
    }

    public int getNumEdges() {
        return (this.gridsz - 1) * (this.gridsz - 1);
    }

    public int getNumNeighbours(int node) {
        int rowid = node / this.gridsz;
        int colid = node % this.gridsz;
        if (rowid > 0 && rowid < this.gridsz - 1) {
            if (colid > 0 && colid < this.gridsz - 1) {
                return 4;
            }
            return 3;
        }
        if (colid > 0 && colid < this.gridsz - 1) {
            return 3;
        }
        return 2;
    }

    public boolean isAdj(int node1, int node2) {
        int rowDiff = node1 / this.gridsz - node2 / this.gridsz;
        int colDiff = node1 % this.gridsz - node2 % this.gridsz;
        return rowDiff == 0 && (colDiff == -1 || colDiff == 1) || colDiff == 0 && (rowDiff == -1 || rowDiff == 1);
    }

    public void removeEdge(int node1, int node2) {
    }
}

