/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.tokenizer;

import iitb.cfilt.cpost.taggen.TaggedToken;
import iitb.cfilt.cpost.utils.UTFConsole;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class TaggedTokenizer {
    private Vector<String> tokens = new Vector();
    private Vector<String> tags = new Vector();
    private Vector<TaggedToken> taggedTokens = new Vector();

    public Vector<String> tokenize(String filename) {
        try {
            BufferedReader btf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
            String line = " ";
            while (line != null) {
                line = btf.readLine();
                if (line == null) continue;
                String[] taggedWords = line.split("\\]");
                int i = 0;
                while (i < taggedWords.length) {
                    if (!taggedWords[i].trim().equals("")) {
                        TaggedToken tt = new TaggedToken(String.valueOf(taggedWords[i].trim()) + " ]");
                        String token = tt.getToken();
                        String tag = tt.getTag();
                        this.tokens.add(token);
                        this.tags.add(tag);
                        this.taggedTokens.add(tt);
                    }
                    ++i;
                }
            }
            btf.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.tokens;
    }

    public Vector<String> tokenizeString(String line) {
        String[] taggedWords = line.split("\\]");
        int i = 0;
        while (i < taggedWords.length) {
            if (!taggedWords[i].trim().equals("")) {
                TaggedToken tt = new TaggedToken(String.valueOf(taggedWords[i].trim()) + " ]");
                String token = tt.getToken();
                String tag = tt.getTag();
                this.tokens.add(token);
                this.tags.add(tag);
                this.taggedTokens.add(tt);
            }
            ++i;
        }
        return this.tokens;
    }

    public Vector<String> getTokens() {
        return this.tokens;
    }

    public Vector<String> getTags() {
        return this.tags;
    }

    public Vector<TaggedToken> getTaggedTokens() {
        return this.taggedTokens;
    }

    public static void main(String[] args) {
        TaggedTokenizer tt = new TaggedTokenizer();
        tt.tokenize(args[0]);
        Vector<TaggedToken> tokens = tt.getTaggedTokens();
        for (TaggedToken token : tokens) {
            UTFConsole.out.println(token);
        }
    }
}

