/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.test;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzer;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleReader;
import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import iitb.cfilt.cpost.newstemmer.Stemmer;
import iitb.cfilt.cpost.vgi.VerbGroup7;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class TestVGI {
    private static Stemmer stemmer;
    private static VerbGroup7 vb;
    private static MorphologicalAnalyzerRuleReader MAR;
    private static MorphologicalAnalyzer ma;
    public static Vector<StemmedToken> stemmedTokens;
    public static Vector<MorphologicallyAnalyzedToken> maTokens;

    public TestVGI() {
        stemmer = new Stemmer();
        vb = new VerbGroup7();
        MAR = new MorphologicalAnalyzerRuleReader();
        ma = new MorphologicalAnalyzer();
    }

    public static void doVGI_forFile(String inFile) {
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF8"));
            String line = "";
            int sentence_no = 1;
            while ((line = bf.readLine()) != null) {
                if (line.length() == 0) continue;
                System.out.println("Sentence:" + sentence_no + "\t");
                String[] tokens = line.split(" ");
                List<String> l = Arrays.asList(tokens);
                Vector<String> tokenList = new Vector<String>(l);
                int[] vgi = new int[tokenList.size()];
                stemmedTokens = stemmer.stem(tokenList);
                maTokens = ma.analyze(stemmedTokens);
                vgi = vb.identifyVerbGroups1(maTokens);
                System.out.println("");
                int i = 0;
                while (i < vgi.length) {
                    System.out.print(String.valueOf(tokens[i]) + "- " + vgi[i] + "\t");
                    ++i;
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] doVGI_forSentence(String sentence, boolean flagWithTags) {
        String rawSentence = "";
        if (flagWithTags) {
            String[] taggedWords = sentence.split("\\]");
            String token = "";
            int i = 0;
            while (i < taggedWords.length) {
                if (taggedWords[i].contains("_")) {
                    String[] taggedWordComponents = taggedWords[i].split("_\\[");
                    token = taggedWordComponents[0].trim() != "" ? taggedWordComponents[0].trim() : ".";
                }
                if (token != "") {
                    rawSentence = String.valueOf(rawSentence) + " " + token;
                }
                ++i;
            }
        } else {
            rawSentence = sentence;
        }
        int[] retArr = new int[rawSentence.length()];
        String[] tokens = rawSentence.split(" ");
        List<String> l = Arrays.asList(tokens);
        Vector<String> tokenList = new Vector<String>(l);
        stemmedTokens = stemmer.stem(tokenList);
        maTokens = ma.analyze(stemmedTokens);
        retArr = vb.identifyVerbGroups1(maTokens);
        return retArr;
    }

    public static void main(String[] args) {
        ConfigReader.read(args[0]);
        stemmer = new Stemmer();
        vb = new VerbGroup7();
        MAR = new MorphologicalAnalyzerRuleReader();
        ma = new MorphologicalAnalyzer();
        TestVGI.doVGI_forFile(args[1]);
    }
}

