/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.tagprocessor;

import iitb.cfilt.cpost.ConfigReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class TagProcessor {
    Vector<String> lexicon = new Vector();
    Vector<String> tagset = new Vector();
    boolean punctuationFlag = false;

    public TagProcessor(String configfile) {
        ConfigReader.read(configfile);
        this.readFile(ConfigReader.get("Tagset.tagMappingFilename"));
    }

    private void readFile(String fileName) {
        String[] tagset_lex = null;
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
            String str = "";
            while ((str = bf.readLine()) != null) {
                tagset_lex = str.split("-");
                int i = 0;
                while (i < tagset_lex.length) {
                    this.tagset.add(tagset_lex[i].trim());
                    this.lexicon.add(tagset_lex[i + 1].trim());
                    i += 2;
                }
            }
            bf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<String> lexicon2Tagset(Vector<String> tags) {
        Vector<String> processedTags = new Vector<String>();
        int index = 0;
        int i = 0;
        while (i < tags.size()) {
            index = this.lexicon.indexOf(tags.elementAt(i));
            processedTags.add(this.tagset.elementAt(index));
            ++i;
        }
        return processedTags;
    }

    public Vector<String> tagset2Lexicon(Vector<String> tags) {
        Vector<String> processedTags = new Vector<String>();
        int index = 0;
        int i = 0;
        while (i < tags.size()) {
            index = this.tagset.indexOf(tags.elementAt(i).trim());
            if (index == -1) {
                String tmp = "";
                String tagTmp = tags.elementAt(i).trim();
                String[] array = tagTmp.split(" ");
                if (array.length > 1) {
                    tmp = "multipleTags";
                    System.out.println("in tmp = multipleTags : tagTmp = '" + tagTmp + "'");
                } else {
                    tmp = tags.elementAt(i).trim();
                }
                index = this.tagset.indexOf(tmp);
            }
            if (this.punctuationFlag) {
                processedTags.add("SYM");
                this.punctuationFlag = false;
            } else if (index == -1) {
                String tag = tags.get(i).trim();
                if (tag.endsWith("C") && this.tagset.contains(tag.substring(0, tag.length() - 1))) {
                    processedTags.add(this.lexicon.get(this.tagset.indexOf(tag.substring(0, tag.length() - 1))));
                } else {
                    processedTags.add("multipleTags");
                    System.out.println("Index = -1 for tag : '" + tags.get(i).trim() + "'");
                }
            } else {
                processedTags.add(this.lexicon.elementAt(index));
            }
            ++i;
        }
        return processedTags;
    }
}

