/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.taggen;

import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;

public class TaggedToken {
    private String token;
    private String tag;
    private Integer AS;
    private String categoryString;

    public TaggedToken(MorphologicallyAnalyzedToken mat) {
        this.token = mat.getToken();
        this.AS = mat.getAS();
        this.categoryString = mat.getAmbiguityScheme();
        this.tag = " ";
    }

    public Integer getAS() {
        return this.AS;
    }

    public String getASString() {
        return this.categoryString;
    }

    public TaggedToken(String taggedWord) {
        String[] taggedWordComponents = taggedWord.split("_\\[");
        this.token = taggedWordComponents[0].trim();
        if (taggedWordComponents.length == 2) {
            taggedWordComponents[1] = taggedWordComponents[1].trim();
            this.tag = " " + taggedWordComponents[1].substring(0, taggedWordComponents[1].length() - 1);
        }
    }

    public void addTag(String tag) {
        if (!this.tag.contains(" " + tag + " ")) {
            this.tag = String.valueOf(this.tag) + tag + " ";
        }
    }

    public String toString() {
        String retVal = String.valueOf(this.token) + "_[";
        retVal = String.valueOf(retVal) + this.tag;
        retVal = String.valueOf(retVal) + "]";
        return retVal;
    }

    public String getToken() {
        return this.token;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

