/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.taggen;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleResult;
import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;
import iitb.cfilt.cpost.taggen.TaggedToken;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class TagGenerator {
    private String tagMappingFilename;
    HashMap<String, String> categoryToTagHash = new HashMap();
    Set<String> tagSet = new HashSet<String>();
    static boolean mmAtTagGen = false;

    static {
        System.out.println("TagGenerator.mmAtTagGen : " + mmAtTagGen);
    }

    public TagGenerator() {
        this.tagMappingFilename = ConfigReader.get("Tagset.tagMappingFilename");
        this.readMapping();
    }

    public Set<String> getTagSet() {
        return this.tagSet;
    }

    private void readMapping() {
        try {
            BufferedReader bsrr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tagMappingFilename), "UTF8"));
            String line = " ";
            while (line != null) {
                line = bsrr.readLine();
                if (line == null || (line = line.trim()).length() == 0 || line.startsWith("//")) continue;
                this.hashIt(line);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void hashIt(String line) {
        String[] lineComponents = line.split("-");
        String tag = lineComponents[0].trim();
        String category = lineComponents[1].trim();
        this.categoryToTagHash.put(category, tag);
        this.tagSet.add(tag);
    }

    public String getTag(String cat) {
        return this.categoryToTagHash.get(cat);
    }

    public Vector<TaggedToken> tag(Vector<MorphologicallyAnalyzedToken> matv) {
        Vector<TaggedToken> retVal = new Vector<TaggedToken>();
        int i = 0;
        while (i < matv.size()) {
            TaggedToken currentToken = this.tag(matv.get(i));
            retVal.add(currentToken);
            ++i;
        }
        return retVal;
    }

    private TaggedToken tag(MorphologicallyAnalyzedToken mat) {
        TaggedToken retVal = new TaggedToken(mat);
        String tag = "";
        if (mat.getMorphologicalAnalyzerOutputs() != null) {
            tag = this.categoryToTagHash.get(mat.getMorphologicalAnalyzerOutputs().get(0).getCategory().trim());
            retVal.setTag(" " + tag + " ");
            return retVal;
        }
        String categoryString = "";
        if (mmAtTagGen) {
            Vector<MorphologicalAnalyzerRuleResult> maov = mat.getMorphologicalAnalyzerOutputs();
            HashSet<String> retSet = new HashSet<String>();
            if (maov != null && maov.size() != 0) {
                int leastSuffixListLength = maov.get(0).getSuffixSize();
                int i = 0;
                while (i < maov.size()) {
                    int currentMin = maov.get(i).getSuffixSize();
                    if (currentMin < leastSuffixListLength) {
                        leastSuffixListLength = currentMin;
                    }
                    ++i;
                }
                i = 0;
                while (i < maov.size()) {
                    int currentSize = maov.get(i).getSuffixSize();
                    if (currentSize == leastSuffixListLength) {
                        retSet.add(maov.get(i).getCategory());
                    }
                    ++i;
                }
                for (String currentCategory : retSet) {
                    categoryString = String.valueOf(categoryString) + currentCategory + "*";
                }
            } else {
                categoryString = mat.getCategoryString().trim();
            }
        } else {
            categoryString = mat.getCategoryString().trim();
        }
        String[] categories = categoryString.split("\\*");
        int i = 0;
        while (i < categories.length) {
            if (this.categoryToTagHash.get(categories[i].trim()) != null) {
                retVal.addTag(this.categoryToTagHash.get(categories[i].trim()));
            }
            ++i;
        }
        if (retVal.getTag().trim().equals("")) {
            try {
                PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF8");
                out.println("Token : " + retVal.getToken() + " Category String : " + categoryString);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }
}

