/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.newstemmer;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.lexicon.WordProperties;
import iitb.cfilt.cpost.lexicon.Wordlist;
import iitb.cfilt.cpost.newstemmer.StemmerRule;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public class StemmerRuleReader {
    private String suffixReplacementRuleFilename = "";
    private String specialCharactersRuleFilename = "";
    private String irregularVerbFilename = "";
    private String derivationalMorphologyRuleFilename = "";
    private String spellingVariationRuleFilename = "";
    private String suffixesFilename = "";
    private String NounSuff = "";
    private String particleFilename = "";
    private String auxSuffixRuleFileName = "";
    private String newSuffixReplacementRuleFilename = "";
    private String newIrregularVerbFilename = "";
    private String newSuffixesFilename = "";
    private HashMap<String, HashMap<String, HashMap<String, Vector<String>>>> newSuffixesHash = new HashMap();
    private HashMap<String, HashMap<String, Vector<StemmerRule>>> newSuffixReplacementRuleHash = new HashMap();
    private HashMap<String, HashMap<String, Vector<String>>> newIrregularVerbHash = new HashMap();
    private HashMap<String, HashMap<String, Vector<String>>> auxSuffixNextTokenRuleHash = new HashMap();
    private HashMap<String, HashMap<String, Vector<String>>> auxSuffixNextRootRuleHash = new HashMap();
    private HashMap<String, HashMap<String, Vector<StemmerRule>>> suffixReplacementRuleHash = new HashMap();
    private HashMap<String, HashMap<String, HashMap<String, Vector<String>>>> suffixesHash = new HashMap();
    private HashMap<String, String> specialCharactersRuleHash = new HashMap();
    private HashMap<String, String> irregularVerbHash = new HashMap();
    private Vector<Vector<String>> irregularVerbVector = new Vector();
    private HashMap<String, HashMap<String, Vector<String>>> derivationalMorphologyRuleHash = new HashMap();
    private HashMap<String, String> spellingVariationRuleHash = new HashMap();
    private Vector<String> NounSuffList = new Vector();
    private Vector<String> SuffPriority = new Vector();
    private Vector<String> particles = new Vector();
    private static Vector<String> particlesStatic = new Vector();
    private static Vector<String> suffixesList = new Vector();
    private boolean populated = false;
    private static HashMap<String, HashMap<String, HashMap<String, Vector<String>>>> suffixesHashStatic = new HashMap();
    private boolean multiSuffix = false;

    public StemmerRuleReader() {
        this.suffixReplacementRuleFilename = ConfigReader.get("NewStemmer.suffixReplacementRuleFilename");
        this.suffixesFilename = ConfigReader.get("NewStemmer.suffixesFilename");
        this.newSuffixReplacementRuleFilename = ConfigReader.get("NewStemmer.newSuffixReplacementRuleFilename");
        this.newSuffixesFilename = ConfigReader.get("NewStemmer.newSuffixesFilename");
        this.newIrregularVerbFilename = ConfigReader.get("Stemmer.newIrregularVerbFilename");
        this.specialCharactersRuleFilename = ConfigReader.get("Stemmer.specialCharactersRuleFilename");
        this.irregularVerbFilename = ConfigReader.get("Stemmer.irregularVerbFilename");
        this.derivationalMorphologyRuleFilename = ConfigReader.get("Stemmer.derivationalMorphologyRuleFilename");
        this.particleFilename = ConfigReader.get("NewStemmer.particlesFile");
        this.spellingVariationRuleFilename = ConfigReader.get("Lexicon.spellingVariationRuleFilename");
        this.auxSuffixRuleFileName = ConfigReader.get("Stemmer.AuxSuffixFile");
    }

    public void populate() {
        if (!this.populated) {
            this.suffixReplacementRuleFilename = ConfigReader.get("NewStemmer.suffixReplacementRuleFilename");
            this.suffixesFilename = ConfigReader.get("NewStemmer.suffixesFilename");
            this.specialCharactersRuleFilename = ConfigReader.get("Stemmer.specialCharactersRuleFilename");
            this.irregularVerbFilename = ConfigReader.get("Stemmer.irregularVerbFilename");
            this.newSuffixReplacementRuleFilename = ConfigReader.get("NewStemmer.newSuffixReplacementRuleFilename");
            this.newSuffixesFilename = ConfigReader.get("NewStemmer.newSuffixesFilename");
            this.newIrregularVerbFilename = ConfigReader.get("Stemmer.newIrregularVerbFilename");
            this.derivationalMorphologyRuleFilename = ConfigReader.get("Stemmer.derivationalMorphologyRuleFilename");
            this.particleFilename = ConfigReader.get("NewStemmer.particlesFile");
            this.spellingVariationRuleFilename = ConfigReader.get("Lexicon.spellingVariationRuleFilename");
            this.NounSuff = ConfigReader.get("Stemmer.NounSuff");
            this.auxSuffixRuleFileName = ConfigReader.get("Stemmer.AuxSuffixFile");
            this.createAllRules();
            this.buildSuffixList();
        }
    }

    public void populate(String baseDir) {
        if (!this.populated) {
            this.suffixReplacementRuleFilename = String.valueOf(baseDir) + ConfigReader.get("NewStemmer.suffixReplacementRuleFilename");
            this.suffixesFilename = String.valueOf(baseDir) + ConfigReader.get("NewStemmer.suffixesFilename");
            this.specialCharactersRuleFilename = String.valueOf(baseDir) + ConfigReader.get("Stemmer.specialCharactersRuleFilename");
            this.irregularVerbFilename = String.valueOf(baseDir) + ConfigReader.get("Stemmer.irregularVerbFilename");
            this.newSuffixReplacementRuleFilename = ConfigReader.get("NewStemmer.newSuffixReplacementRuleFilename");
            this.newSuffixesFilename = ConfigReader.get("NewStemmer.newSuffixesFilename");
            this.newIrregularVerbFilename = ConfigReader.get("Stemmer.newIrregularVerbFilename");
            this.derivationalMorphologyRuleFilename = String.valueOf(baseDir) + ConfigReader.get("Stemmer.derivationalMorphologyRuleFilename");
            this.particleFilename = String.valueOf(baseDir) + ConfigReader.get("NewStemmer.particlesFile");
            this.spellingVariationRuleFilename = ConfigReader.get("Lexicon.spellingVariationRuleFilename");
            this.NounSuff = String.valueOf(baseDir) + ConfigReader.get("Stemmer.NounSuff");
            this.auxSuffixRuleFileName = String.valueOf(baseDir) + ConfigReader.get("Stemmer.AuxSuffixFile");
            this.createAllRules();
            this.buildSuffixList();
        }
    }

    private void createAllRules() {
        this.createRules(this.suffixReplacementRuleFilename);
        this.createRules(this.suffixesFilename);
        this.createRules(this.newSuffixReplacementRuleFilename);
        this.createRules(this.newSuffixesFilename);
        this.createRules(this.newIrregularVerbFilename);
        this.createRules(this.specialCharactersRuleFilename);
        this.createRules(this.irregularVerbFilename);
        this.createRules(this.derivationalMorphologyRuleFilename);
        this.createRules(this.particleFilename);
        this.createRules(this.spellingVariationRuleFilename);
        this.createRules(this.NounSuff);
        this.createRules(this.auxSuffixRuleFileName);
    }

    private void createRules(String filename) {
        try {
            BufferedReader bsrr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
            String line = " ";
            while (line != null) {
                line = bsrr.readLine();
                if (line == null || (line = line.trim()).length() == 0 || line.startsWith("//")) continue;
                this.hashIt(line, filename);
            }
            bsrr.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void hashIt(String line, String filename) {
        if (filename.equals(this.suffixReplacementRuleFilename)) {
            this.hashSuffixReplacementRule(line);
        } else if (filename.equals(this.suffixesFilename)) {
            this.hashSuffixes(line);
        } else if (filename.equals(this.newSuffixReplacementRuleFilename)) {
            this.hashNewSuffixReplacementRule(line);
        } else if (filename.equals(this.newSuffixesFilename)) {
            this.hashNewSuffixes(line);
        } else if (filename.equals(this.specialCharactersRuleFilename)) {
            this.hashSpecialCharactersRule(line);
        } else if (filename.equals(this.irregularVerbFilename)) {
            this.hashIrregularVerb(line);
        } else if (filename.equals(this.newIrregularVerbFilename)) {
            this.hashNewIrregularVerb(line);
        } else if (filename.equals(this.derivationalMorphologyRuleFilename)) {
            this.hashDerivationalMorphologyRule(line);
        } else if (filename.equals(this.particleFilename)) {
            this.hashParticles(line);
        } else if (filename.equals(this.NounSuff)) {
            this.hashNounSuff(line);
        } else if (filename.equals(this.spellingVariationRuleFilename)) {
            this.hashSpellingVariationRule(line);
        } else if (filename.equals(this.auxSuffixRuleFileName)) {
            this.hashAuxSuffixRule(line);
        }
    }

    private void hashNewSuffixReplacementRule(String line) {
        String[] lineComponents = line.split(",");
        String category = lineComponents[0].trim();
        String paradigm = lineComponents[1].trim();
        String ultimateInsertion = lineComponents[2].trim();
        String ultimateDeletion = lineComponents[3].trim();
        String penultimateInsertion = lineComponents[4].trim();
        String penultimateDeletion = lineComponents[5].trim();
        int priority = Integer.parseInt(lineComponents[6].trim());
        String suffixToReplace = lineComponents[7].trim();
        String suffix = "";
        if (lineComponents.length == 9) {
            suffix = lineComponents[8].trim();
        }
        StemmerRule sr = new StemmerRule(paradigm, category, ultimateInsertion, ultimateDeletion, penultimateInsertion, penultimateDeletion, suffixToReplace, priority, suffix);
        if (this.newSuffixReplacementRuleHash.containsKey(category)) {
            HashMap<String, Vector<StemmerRule>> suffixStemmerRuleHash = this.newSuffixReplacementRuleHash.get(category);
            if (suffixStemmerRuleHash.containsKey(paradigm)) {
                Vector<StemmerRule> srv = suffixStemmerRuleHash.get(paradigm);
                srv.add(sr);
            } else {
                Vector<StemmerRule> srv = new Vector<StemmerRule>();
                srv.add(sr);
                suffixStemmerRuleHash.put(paradigm, srv);
            }
        } else {
            Vector<StemmerRule> srv = new Vector<StemmerRule>();
            srv.add(sr);
            HashMap<String, Vector<StemmerRule>> suffixStemmerRuleHash = new HashMap<String, Vector<StemmerRule>>();
            suffixStemmerRuleHash.put(paradigm, srv);
            this.newSuffixReplacementRuleHash.put(category, suffixStemmerRuleHash);
        }
    }

    private void hashNewSuffixes(String line) {
        String[] lineComponents = line.split(",");
        if (lineComponents.length == 4) {
            String category = lineComponents[0].trim();
            String type = lineComponents[1].trim();
            String suffix = lineComponents[2].trim();
            String flag = lineComponents[3].trim();
            if (this.newSuffixesHash.containsKey(category)) {
                HashMap<String, HashMap<String, Vector<String>>> catHash = this.newSuffixesHash.get(category);
                if (catHash.containsKey(type)) {
                    HashMap<String, Vector<String>> typeHash = catHash.get(type);
                    if (typeHash.containsKey(flag)) {
                        Vector<String> suffixes = typeHash.get(flag);
                        suffixes.add(suffix);
                    } else {
                        Vector<String> suffixes = new Vector<String>();
                        suffixes.add(suffix);
                        typeHash.put(flag, suffixes);
                    }
                } else {
                    Vector<String> suffixes = new Vector<String>();
                    suffixes.add(suffix);
                    HashMap<String, Vector<String>> typeHash = new HashMap<String, Vector<String>>();
                    typeHash.put(flag, suffixes);
                    catHash.put(type, typeHash);
                }
            } else {
                Vector<String> suffixes = new Vector<String>();
                suffixes.add(suffix);
                HashMap<String, Vector<String>> typeHash = new HashMap<String, Vector<String>>();
                typeHash.put(flag, suffixes);
                HashMap<String, HashMap<String, Vector<String>>> catHash = new HashMap<String, HashMap<String, Vector<String>>>();
                catHash.put(type, typeHash);
                this.newSuffixesHash.put(category, catHash);
            }
        }
    }

    private void hashNewIrregularVerb(String line) {
        String[] lineComponents = line.split(",");
        if (lineComponents.length == 4 || lineComponents.length == 5) {
            String irregularForm = lineComponents[0].trim();
            String regularForm = lineComponents[1].trim();
            String paradigm = lineComponents[2].trim();
            String category = lineComponents[3].trim();
            Vector<String> temp = new Vector<String>();
            temp.add(regularForm);
            temp.add(paradigm);
            temp.add(category);
            if (this.newIrregularVerbHash.containsKey(category)) {
                HashMap<String, Vector<String>> catHash = this.newIrregularVerbHash.get(category);
                catHash.put(irregularForm, temp);
            } else {
                HashMap<String, Vector<String>> catHash = new HashMap<String, Vector<String>>();
                catHash.put(irregularForm, temp);
                this.newIrregularVerbHash.put(category, catHash);
            }
        }
    }

    private void hashAuxSuffixRule(String line) {
        boolean next_is_token = true;
        if (line.equalsIgnoreCase("Next-is-Token")) {
            next_is_token = true;
        } else if (line.equalsIgnoreCase("Next-is-Root")) {
            next_is_token = false;
        } else {
            HashMap<String, HashMap<String, Vector<String>>> tmpHash = next_is_token ? this.auxSuffixNextTokenRuleHash : this.auxSuffixNextRootRuleHash;
            String[] lineComponents = line.trim().split("/");
            String auxList = lineComponents[0].trim();
            String suffixList = lineComponents[1].trim();
            String nextAuxList = "Null";
            boolean nextAux = false;
            if (lineComponents.length == 3) {
                nextAux = true;
                nextAuxList = lineComponents[2].trim();
            }
            String[] aux = auxList.trim().split(",");
            String[] suffixes = suffixList.trim().split(",");
            Vector<String> next_aux = new Vector<String>();
            if (nextAux) {
                String[] nextaux = nextAuxList.trim().split(",");
                int k = 0;
                while (k < nextaux.length) {
                    if (nextaux[k] != "" && nextaux[k].trim() != " ") {
                        next_aux.add(nextaux[k].trim());
                    }
                    ++k;
                }
            }
            int i = 0;
            while (i < aux.length) {
                Vector curNextAuxList;
                String curSuffix;
                int j;
                HashMap<Object, Object> aux_suffixRuleHash;
                String curAux = aux[i].trim();
                if (tmpHash.containsKey(curAux)) {
                    aux_suffixRuleHash = tmpHash.get(curAux);
                    j = 0;
                    while (j < suffixes.length) {
                        curSuffix = suffixes[j].trim();
                        if (curSuffix != "" && curSuffix != " ") {
                            if (aux_suffixRuleHash.containsKey(curSuffix)) {
                                curNextAuxList = (Vector)aux_suffixRuleHash.get(curSuffix);
                                curNextAuxList.addAll(next_aux);
                            } else {
                                aux_suffixRuleHash.put(curSuffix, next_aux);
                            }
                        }
                        ++j;
                    }
                } else {
                    aux_suffixRuleHash = new HashMap();
                    j = 0;
                    while (j < suffixes.length) {
                        curSuffix = suffixes[j].trim();
                        if (curSuffix != "" && curSuffix != " ") {
                            if (aux_suffixRuleHash.containsKey(curSuffix)) {
                                curNextAuxList = (Vector)aux_suffixRuleHash.get(curSuffix);
                                curNextAuxList.addAll(next_aux);
                            } else {
                                aux_suffixRuleHash.put(curSuffix, next_aux);
                            }
                        }
                        ++j;
                    }
                    tmpHash.put(curAux, aux_suffixRuleHash);
                }
                ++i;
            }
        }
    }

    private void hashNounSuff(String line) {
        String[] lineComponents = line.split(",");
        if (this.NounSuffList.indexOf(lineComponents[0].trim()) == -1) {
            this.NounSuffList.add(lineComponents[0].trim());
            this.SuffPriority.add(lineComponents[1].trim());
        }
    }

    private void hashParticles(String line) {
        this.particles.add(line.trim());
    }

    private void hashSpellingVariationRule(String line) {
        String[] lineComponents = line.split(",");
        if (lineComponents.length == 2) {
            this.spellingVariationRuleHash.put(lineComponents[0].trim(), lineComponents[1].trim());
        } else {
            this.spellingVariationRuleHash.put(lineComponents[0].trim(), "");
        }
    }

    private void hashDerivationalMorphologyRule(String line) {
        String[] lineComponents = line.trim().split(" ");
        String suffix = lineComponents[1].trim();
        String rootCat = lineComponents[3].trim();
        String newCat = lineComponents[5].trim();
        if (this.derivationalMorphologyRuleHash.containsKey(suffix)) {
            HashMap<String, Vector<String>> rootCategoryToNewCatogoriesHash = this.derivationalMorphologyRuleHash.get(suffix);
            if (rootCategoryToNewCatogoriesHash.containsKey(rootCat)) {
                Vector<String> newCategoriesVector = rootCategoryToNewCatogoriesHash.get(rootCat);
                String[] newCategories = newCat.split("\\,");
                int i = 0;
                while (i < newCategories.length) {
                    if (!newCategoriesVector.contains(newCategories[i])) {
                        newCategoriesVector.add(newCategories[i]);
                    }
                    ++i;
                }
            } else {
                String[] newCategories = newCat.split("\\,");
                Vector<String> newCategoriesVector = new Vector<String>();
                int i = 0;
                while (i < newCategories.length) {
                    if (!newCategoriesVector.contains(newCategories[i])) {
                        newCategoriesVector.add(newCategories[i]);
                    }
                    ++i;
                }
                rootCategoryToNewCatogoriesHash.put(rootCat, newCategoriesVector);
            }
        } else {
            HashMap rootCategoryToNewCatogoriesHash = new HashMap();
            String[] newCategories = newCat.split("\\,");
            Vector<String> newCategoriesVector = new Vector<String>();
            int i = 0;
            while (i < newCategories.length) {
                if (!newCategoriesVector.contains(newCategories[i])) {
                    newCategoriesVector.add(newCategories[i]);
                }
                ++i;
            }
            rootCategoryToNewCatogoriesHash.put(rootCat, newCategoriesVector);
            this.derivationalMorphologyRuleHash.put(suffix, rootCategoryToNewCatogoriesHash);
        }
    }

    private void hashIrregularVerb(String line) {
        String[] lineComponents = line.split(",");
        if (lineComponents.length == 4 || lineComponents.length == 5) {
            String irregularForm = lineComponents[0].trim();
            String regularForm = lineComponents[1].trim();
            String paradigm = lineComponents[2].trim();
            String category = lineComponents[3].trim();
            String suffix = null;
            if (lineComponents.length == 5) {
                suffix = lineComponents[4].trim();
            }
            Vector<String> temp = new Vector<String>();
            temp.add(irregularForm);
            temp.add(regularForm);
            temp.add(paradigm);
            temp.add(category);
            if (suffix != null) {
                temp.add(suffix);
            }
            this.irregularVerbVector.add(temp);
            this.irregularVerbHash.put(irregularForm, regularForm);
        }
    }

    private void hashSpecialCharactersRule(String line) {
        String regex;
        String paradigm;
        String[] lineComponents = (line = line.replaceFirst(",", "-split-")).split("-split-");
        if (lineComponents.length == 2) {
            paradigm = lineComponents[0].trim();
            regex = lineComponents[1].trim();
        } else {
            paradigm = "";
            regex = lineComponents[0].trim();
        }
        this.specialCharactersRuleHash.put(regex, paradigm);
    }

    private void hashSuffixReplacementRule(String line) {
        String[] lineComponents = line.split(",");
        String category = lineComponents[0].trim();
        String paradigm = lineComponents[1].trim();
        String ultimateInsertion = lineComponents[2].trim();
        String ultimateDeletion = lineComponents[3].trim();
        String penultimateInsertion = lineComponents[4].trim();
        String penultimateDeletion = lineComponents[5].trim();
        int priority = Integer.parseInt(lineComponents[6].trim());
        String suffix = null;
        if (lineComponents.length == 8) {
            suffix = lineComponents[7].trim();
        }
        StemmerRule sr = new StemmerRule(paradigm, category, ultimateInsertion, ultimateDeletion, penultimateInsertion, penultimateDeletion, suffix, priority);
        if (this.suffixReplacementRuleHash.containsKey(category)) {
            HashMap<String, Vector<StemmerRule>> suffixStemmerRuleHash = this.suffixReplacementRuleHash.get(category);
            if (suffixStemmerRuleHash.containsKey(paradigm)) {
                Vector<StemmerRule> srv = suffixStemmerRuleHash.get(paradigm);
                srv.add(sr);
            } else {
                Vector<StemmerRule> srv = new Vector<StemmerRule>();
                srv.add(sr);
                suffixStemmerRuleHash.put(paradigm, srv);
            }
        } else {
            Vector<StemmerRule> srv = new Vector<StemmerRule>();
            srv.add(sr);
            HashMap<String, Vector<StemmerRule>> suffixStemmerRuleHash = new HashMap<String, Vector<StemmerRule>>();
            suffixStemmerRuleHash.put(paradigm, srv);
            this.suffixReplacementRuleHash.put(category, suffixStemmerRuleHash);
        }
    }

    private void hashSuffixes(String line) {
        String[] lineComponents = line.split(",");
        String category = lineComponents[0].trim();
        String type = lineComponents[1].trim();
        String suffix = lineComponents[2].trim();
        int l = suffix.length();
        String lastchar = suffix.substring(l - 1);
        if (!suffixesList.contains(suffix)) {
            suffixesList.add(suffix);
        }
        if (this.suffixesHash.containsKey(category)) {
            HashMap<String, HashMap<String, Vector<String>>> typeSuffixHash = this.suffixesHash.get(category);
            if (typeSuffixHash.containsKey(type)) {
                HashMap<String, Vector<String>> lastcharSuffixHash = typeSuffixHash.get(type);
                if (lastcharSuffixHash.containsKey(lastchar)) {
                    Vector<String> suffixVector = lastcharSuffixHash.get(lastchar);
                    suffixVector.add(suffix);
                    lastcharSuffixHash.put(lastchar, suffixVector);
                    typeSuffixHash.put(type, lastcharSuffixHash);
                    this.suffixesHash.put(category, typeSuffixHash);
                } else {
                    Vector<String> suffixVector = new Vector<String>();
                    suffixVector.add(suffix);
                    lastcharSuffixHash.put(lastchar, suffixVector);
                    typeSuffixHash.put(type, lastcharSuffixHash);
                    this.suffixesHash.put(category, typeSuffixHash);
                }
            } else {
                HashMap lastcharSuffixHash = new HashMap();
                Vector<String> suffixVector = new Vector<String>();
                suffixVector.add(suffix);
                lastcharSuffixHash.put(lastchar, suffixVector);
                typeSuffixHash.put(type, lastcharSuffixHash);
                this.suffixesHash.put(category, typeSuffixHash);
            }
        } else {
            HashMap typeSuffixHash = new HashMap();
            HashMap lastcharSuffixHash = new HashMap();
            Vector<String> suffixVector = new Vector<String>();
            suffixVector.add(suffix);
            lastcharSuffixHash.put(lastchar, suffixVector);
            typeSuffixHash.put(type, lastcharSuffixHash);
            this.suffixesHash.put(category, typeSuffixHash);
        }
    }

    public String removeParticle(String token) {
        int i = 0;
        while (i < this.particles.size()) {
            if (token.endsWith(this.particles.get(i))) {
                token = token.replaceAll(String.valueOf(this.particles.get(i)) + "$", "");
                return token;
            }
            ++i;
        }
        return token;
    }

    public Vector<StemmerRuleResult> removeCharamSuffix(String token, String category) {
        Vector<StemmerRuleResult> retVal = new Vector<StemmerRuleResult>();
        int l = token.length();
        if (l == 0) {
            return null;
        }
        String lastchar = token.substring(l - 1);
        Vector<Object> suffixes3 = new Vector();
        Vector<String> endsuffixes3 = new Vector<String>();
        if (this.suffixesHash.containsKey(category) && this.suffixesHash.get(category).containsKey("3")) {
            suffixes3 = this.suffixesHash.get(category).get("3").get(lastchar);
        }
        int i = 0;
        while (suffixes3 != null && i < suffixes3.size()) {
            if (token.endsWith((String)suffixes3.get(i))) {
                endsuffixes3.add((String)suffixes3.get(i));
            }
            ++i;
        }
        if (endsuffixes3.size() == 0) {
            return null;
        }
        Set<String> paradigms = this.suffixReplacementRuleHash.get(category).keySet();
        int i2 = 0;
        while (i2 < endsuffixes3.size()) {
            String suff = (String)endsuffixes3.get(i2);
            Iterator<String> parIter = paradigms.iterator();
            String newtoken = token.replaceAll(String.valueOf(suff) + "$", "");
            block2: while (parIter.hasNext()) {
                String par = parIter.next();
                Vector<StemmerRule> rules = this.suffixReplacementRuleHash.get(category).get(par);
                int j = 0;
                while (j < rules.size()) {
                    WordProperties wp;
                    StemmerRule currentRule = rules.get(j);
                    StemmerRuleResult str = currentRule.applyOn(newtoken, suff);
                    if (str != null && (wp = Wordlist.lookup(str.getRoot(), str.getParadigm())) != null) {
                        if (retVal.contains(str)) continue block2;
                        retVal.add(str);
                        continue block2;
                    }
                    ++j;
                }
            }
            if (this.hasIrregularRootForm(newtoken) || this.hasIrregularRootForm(token)) {
                String regularRootForm = null;
                String new_paradigm = "";
                String new_category = "";
                String suffixStart = "";
                Vector<Vector<String>> results = this.getRegularRootForm(newtoken);
                int z = 0;
                while (z < results.size()) {
                    StemmerRuleResult str;
                    regularRootForm = results.get(z).get(1);
                    new_paradigm = results.get(z).get(2);
                    new_category = results.get(z).get(3);
                    if (results.get(z).size() == 5) {
                        suffixStart = results.get(z).get(4);
                        if (suff != null && !suff.startsWith(suffixStart)) break;
                    }
                    if (!retVal.contains(str = new StemmerRuleResult(regularRootForm, new_paradigm, new_category, "", suff)) && new_category.equals(category)) {
                        retVal.add(str);
                    }
                    ++z;
                }
            }
            ++i2;
        }
        if (retVal.size() == 0) {
            return null;
        }
        return retVal;
    }

    public Vector<StemmerRuleResult> applySRRs(String token, String category) {
        if (token.length() == 0 || token == null) {
            return null;
        }
        Vector<StemmerRuleResult> retval = new Vector<StemmerRuleResult>();
        String firstchar = token.substring(0, 1);
        int l = token.length();
        String lastchar = token.substring(l - 1);
        Vector<Object> suffixes1 = new Vector();
        Vector<String> endsuffixes1 = new Vector<String>();
        if (this.suffixesHash.containsKey(category) && this.suffixesHash.get(category).containsKey("1")) {
            suffixes1 = this.suffixesHash.get(category).get("1").get(lastchar);
        }
        int i = 0;
        while (suffixes1 != null && i < suffixes1.size()) {
            if (token.endsWith((String)suffixes1.get(i))) {
                endsuffixes1.add((String)suffixes1.get(i));
            }
            ++i;
        }
        Set<String> paradigms = this.suffixReplacementRuleHash.get(category).keySet();
        int i2 = 0;
        while (i2 < endsuffixes1.size()) {
            String suff = (String)endsuffixes1.get(i2);
            Iterator<String> parIter = paradigms.iterator();
            String newtoken = token.replaceAll(String.valueOf(suff) + "$", "");
            block2: while (parIter.hasNext()) {
                String par = parIter.next();
                Vector<StemmerRule> rules = this.suffixReplacementRuleHash.get(category).get(par);
                int j = 0;
                while (rules != null && j < rules.size()) {
                    StemmerRule currentRule = rules.get(j);
                    StemmerRuleResult str = currentRule.applyOn(newtoken, suff);
                    if (str != null) {
                        WordProperties wp = Wordlist.lookup(str.getRoot(), str.getParadigm());
                        boolean valid = true;
                        if (category.equals("verb_aux")) {
                            valid = this.auxSuffixNextRootRuleHash.containsKey(str.getRoot());
                            if (valid) {
                                valid = this.auxSuffixNextRootRuleHash.get(str.getRoot()).containsKey(str.getSuffixList().get(0));
                            }
                            if (!valid && (valid = this.auxSuffixNextTokenRuleHash.containsKey(str.getRoot()))) {
                                valid = this.auxSuffixNextTokenRuleHash.get(str.getRoot()).containsKey(str.getSuffixList().get(0));
                            }
                        }
                        if (wp != null && valid) {
                            if (retval.contains(str)) continue block2;
                            retval.add(str);
                            continue block2;
                        }
                    }
                    ++j;
                }
            }
            if (this.hasIrregularRootForm(newtoken) || this.hasIrregularRootForm(token)) {
                String regularRootForm = null;
                String new_paradigm = "";
                String new_category = "";
                String suffixStart = "";
                Vector<Vector<String>> results = this.getRegularRootForm(newtoken);
                int z = 0;
                while (z < results.size()) {
                    StemmerRuleResult str;
                    regularRootForm = results.get(z).get(1);
                    new_paradigm = results.get(z).get(2);
                    new_category = results.get(z).get(3);
                    if (results.get(z).size() == 5) {
                        suffixStart = results.get(z).get(4);
                        if (suff != null && !suff.startsWith(suffixStart)) break;
                    }
                    if (!retval.contains(str = new StemmerRuleResult(regularRootForm, new_paradigm, new_category, "", suff)) && new_category.equals(category)) {
                        retval.add(str);
                    }
                    ++z;
                }
            }
            ++i2;
        }
        if (this.multiSuffix) {
            Vector<Object> suffixes2 = new Vector();
            Vector<String> endsuffixes2 = new Vector<String>();
            if (this.suffixesHash.containsKey(category) && this.suffixesHash.get(category).containsKey("2")) {
                suffixes2 = this.suffixesHash.get(category).get("2").get(lastchar);
            }
            int i3 = 0;
            while (suffixes2 != null && i3 < suffixes2.size()) {
                if (token.endsWith((String)suffixes2.get(i3))) {
                    endsuffixes2.add((String)suffixes2.get(i3));
                }
                ++i3;
            }
            int maxl = 0;
            String maxSuff = "";
            String newtoken_maxl = "";
            int i4 = 0;
            while (i4 < endsuffixes2.size()) {
                String suff = (String)endsuffixes2.get(i4);
                Iterator<String> parIter = paradigms.iterator();
                String newtoken = token.replaceAll(String.valueOf(suff) + "$", "");
                block7: while (parIter.hasNext()) {
                    String par = parIter.next();
                    Vector<StemmerRule> rules = this.suffixReplacementRuleHash.get(category).get(par);
                    int j = 0;
                    while (rules != null && j < rules.size()) {
                        StemmerRule currentRule = rules.get(j);
                        StemmerRuleResult str = currentRule.applyOn(newtoken, suff);
                        if (str != null) {
                            WordProperties wp = Wordlist.lookup(str.getRoot(), str.getParadigm());
                            boolean valid = true;
                            if (category.equals("verb_aux")) {
                                valid = this.auxSuffixNextRootRuleHash.containsKey(str.getRoot());
                                if (valid) {
                                    valid = this.auxSuffixNextRootRuleHash.get(str.getRoot()).containsKey(str.getSuffixList().get(0));
                                }
                                if (!valid && (valid = this.auxSuffixNextTokenRuleHash.containsKey(str.getRoot()))) {
                                    valid = this.auxSuffixNextTokenRuleHash.get(str.getRoot()).containsKey(str.getSuffixList().get(0));
                                }
                            }
                            if (wp != null) {
                                if (retval.contains(str)) continue block7;
                                retval.add(str);
                                continue block7;
                            }
                        }
                        ++j;
                    }
                }
                if (this.hasIrregularRootForm(newtoken) || this.hasIrregularRootForm(token)) {
                    String regularRootForm = null;
                    String new_paradigm = "";
                    String new_category = "";
                    String suffixStart = "";
                    Vector<Vector<String>> results = this.getRegularRootForm(newtoken);
                    int z = 0;
                    while (z < results.size()) {
                        StemmerRuleResult str;
                        regularRootForm = results.get(z).get(1);
                        new_paradigm = results.get(z).get(2);
                        new_category = results.get(z).get(3);
                        if (results.get(z).size() == 5) {
                            suffixStart = results.get(z).get(4);
                            if (suff != null && !suff.startsWith(suffixStart)) break;
                        }
                        if (!retval.contains(str = new StemmerRuleResult(regularRootForm, new_paradigm, new_category, "", suff)) && new_category.equals(category)) {
                            retval.add(str);
                        }
                        ++z;
                    }
                }
                if (suff.length() > maxl) {
                    maxl = suff.length();
                    newtoken_maxl = newtoken;
                    maxSuff = suff;
                }
                ++i4;
            }
            if (retval.size() == 0 && endsuffixes2.size() > 0) {
                Vector<StemmerRuleResult> strv = this.applySRRs(newtoken_maxl, category);
                int k = 0;
                while (strv != null && k < strv.size()) {
                    if (strv.get(k) != null) {
                        strv.get(k).addSuffix(maxSuff);
                        if (!retval.contains(strv.get(k))) {
                            retval.add(strv.get(k));
                        }
                    }
                    ++k;
                }
            }
        }
        return retval;
    }

    public Vector<StemmerRuleResult> checkLexEntries(String token, String category, String suffix) {
        Vector<StemmerRuleResult> retVal = new Vector<StemmerRuleResult>();
        Vector<WordProperties> tokenProperties = Wordlist.searchWordlistFor(token);
        if (tokenProperties != null) {
            int i = 0;
            while (i < tokenProperties.size()) {
                StemmerRuleResult srresult;
                WordProperties tokenProperty = tokenProperties.get(i);
                if (tokenProperty.getCategory().equals(category) && !retVal.contains(srresult = new StemmerRuleResult(token, tokenProperty.getParadigm(), category, "", suffix))) {
                    retVal.add(srresult);
                }
                ++i;
            }
        }
        return retVal;
    }

    public Vector<StemmerRuleResult> checkLexEntries(String token, String category, String paradigm, String suffix) {
        Vector<StemmerRuleResult> retVal = new Vector<StemmerRuleResult>();
        Vector<WordProperties> tokenProperties = Wordlist.searchWordlistFor(token);
        if (tokenProperties != null) {
            int i = 0;
            while (i < tokenProperties.size()) {
                StemmerRuleResult srresult;
                WordProperties tokenProperty = tokenProperties.get(i);
                if (tokenProperty.getCategory().equals(category) && tokenProperty.getParadigm().equals(paradigm) && !retVal.contains(srresult = new StemmerRuleResult(token, paradigm, category, "", suffix))) {
                    retVal.add(srresult);
                }
                ++i;
            }
        }
        return retVal;
    }

    public Vector<StemmerRuleResult> applySRR(String token, String category) {
        if (token.length() == 0 || token == null) {
            return null;
        }
        Vector<StemmerRuleResult> retval = new Vector<StemmerRuleResult>();
        if (this.newSuffixReplacementRuleHash.keySet().contains(category)) {
            HashMap<String, Vector<StemmerRule>> catHash = this.newSuffixReplacementRuleHash.get(category);
            Set<String> paradigmKeys = catHash.keySet();
            for (String paradigm : paradigmKeys) {
                Vector<StemmerRule> stemmerRules = this.newSuffixReplacementRuleHash.get(category).get(paradigm);
                int i = 0;
                while (i < stemmerRules.size()) {
                    StemmerRule stemmerRule = stemmerRules.get(i);
                    String stem = stemmerRule.applyRule(token);
                    Vector<StemmerRuleResult> srv = this.checkLexEntries(stem, category, paradigm, stemmerRule.getSuffix());
                    if (!srv.isEmpty()) {
                        int j = 0;
                        while (j < srv.size()) {
                            retval.add(srv.get(j));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return retval;
    }

    public Vector<StemmerRuleResult> applyIrregularVerbMapping(String token, String category) {
        HashMap<String, Cloneable> catHash;
        Vector<StemmerRuleResult> srrv = new Vector<StemmerRuleResult>();
        Vector suffixes = new Vector();
        if (this.newSuffixesHash.keySet().contains(category.trim())) {
            catHash = this.newSuffixesHash.get(category.trim());
            Set<String> typeKeys = catHash.keySet();
            for (String type : typeKeys) {
                HashMap<String, Vector<String>> typeHash = this.newSuffixesHash.get(category).get(type);
                if (!typeHash.keySet().contains("1")) continue;
                suffixes.addAll(typeHash.get("1"));
            }
        }
        if (!this.newIrregularVerbHash.keySet().contains(category)) {
            return srrv;
        }
        catHash = this.newIrregularVerbHash.get(category);
        if (!suffixes.isEmpty()) {
            int suf = 0;
            while (suf < suffixes.size()) {
                String suffix = (String)suffixes.get(suf);
                if (token.endsWith(suffix)) {
                    String paradigm;
                    String cat;
                    String regularStem;
                    Vector<StemmerRuleResult> srv;
                    String stem = token.replaceAll(String.valueOf(suffix) + "$", "");
                    if (catHash.keySet().contains(stem) && ((String)((Vector)catHash.get(stem)).get(2)).equals(category) && !(srv = this.checkLexEntries(regularStem = (String)((Vector)catHash.get(stem)).get(0), cat = (String)((Vector)catHash.get(stem)).get(2), paradigm = (String)((Vector)catHash.get(stem)).get(1), suffix)).isEmpty()) {
                        int i = 0;
                        while (i < srv.size()) {
                            srrv.add(srv.get(i));
                            ++i;
                        }
                    }
                }
                ++suf;
            }
        }
        return srrv;
    }

    public Vector<StemmerRuleResult> applySuffixRules(String token, String category) {
        Vector<StemmerRuleResult> srrv = new Vector<StemmerRuleResult>();
        Vector suffixes = new Vector();
        if (this.newSuffixesHash.keySet().contains(category.trim())) {
            HashMap<String, HashMap<String, Vector<String>>> catHash = this.newSuffixesHash.get(category.trim());
            Set<String> typeKeys = catHash.keySet();
            for (String type : typeKeys) {
                HashMap<String, Vector<String>> typeHash = this.newSuffixesHash.get(category).get(type);
                if (typeHash.keySet().contains("0")) {
                    suffixes.addAll(typeHash.get("0"));
                }
                if (typeHash.keySet().contains("1")) {
                    suffixes.addAll(typeHash.get("1"));
                }
                if (!typeHash.keySet().contains("2")) continue;
                suffixes.addAll(typeHash.get("2"));
            }
        } else {
            System.out.println("Not Found..");
        }
        if (!suffixes.isEmpty()) {
            int suf = 0;
            while (suf < suffixes.size()) {
                String stem;
                Vector<StemmerRuleResult> srv;
                String suffix = (String)suffixes.get(suf);
                if (token.endsWith(suffix) && !(srv = this.checkLexEntries(stem = token.replaceAll(String.valueOf(suffix) + "$", ""), category, suffix)).isEmpty()) {
                    int i = 0;
                    while (i < srv.size()) {
                        srrv.add(srv.get(i));
                        ++i;
                    }
                }
                ++suf;
            }
        }
        return srrv;
    }

    public boolean checkForSuffixPriority(String token, StemmerRuleResult currentResult) {
        String suff;
        if (currentResult.getSuffixList().size() > 1 && (suff = currentResult.getSuffixList().getLast().trim()).length() > 0) {
            String lastChar = suff.substring(suff.length() - 1);
            HashMap<String, Vector<StemmerRule>> suffixStemmerRuleHash = this.suffixReplacementRuleHash.get(lastChar);
            Vector<StemmerRule> stemmerRules = suffixStemmerRuleHash.get(suff);
            Iterator<StemmerRule> stemmerRulesIter = stemmerRules.iterator();
            StemmerRule currentRule = null;
            while (stemmerRulesIter.hasNext()) {
                currentRule = stemmerRulesIter.next();
                if (!currentResult.getParadigm().trim().equals(currentRule.getParadigm().trim())) continue;
                if (currentRule.getPriority() == 2) {
                    return false;
                }
                if (currentRule.getPriority() == 2) continue;
                return true;
            }
        }
        return true;
    }

    public StemmerRuleResult applySpecialCharacterRulesOn(String token) {
        StemmerRuleResult retVal = null;
        Set<String> regexes = this.specialCharactersRuleHash.keySet();
        for (String regex : regexes) {
            if (!token.matches(regex)) continue;
            String paradigm = this.specialCharactersRuleHash.get(regex);
            retVal = new StemmerRuleResult(token, paradigm, paradigm, "", "");
        }
        return retVal;
    }

    boolean valid(StemmerRuleResult str, String category) {
        boolean valid = true;
        if (category.equals("verb_aux")) {
            valid = this.auxSuffixNextRootRuleHash.containsKey(str.getRoot());
            if (valid) {
                valid = this.auxSuffixNextRootRuleHash.get(str.getRoot()).containsKey(str.getSuffixList().get(0));
            }
            if (!valid && (valid = this.auxSuffixNextTokenRuleHash.containsKey(str.getRoot()))) {
                valid = this.auxSuffixNextTokenRuleHash.get(str.getRoot()).containsKey(str.getSuffixList().get(0));
            }
        }
        return valid;
    }

    public void buildSuffixList() {
        suffixesHashStatic = this.suffixesHash;
        particlesStatic = this.particles;
    }

    public static boolean endsWithNounSuff(String word) {
        int l = word.length();
        String lastchar = word.substring(l - 1);
        Vector<Object> suffixes1 = new Vector();
        Vector<Object> suffixes2 = new Vector();
        Vector<Object> suffixes3 = new Vector();
        Vector<String> endsuffixes = new Vector<String>();
        if (suffixesHashStatic.containsKey("noun") && suffixesHashStatic.get("noun").containsKey("1")) {
            suffixes1 = suffixesHashStatic.get("noun").get("1").get(lastchar);
        }
        if (suffixesHashStatic.containsKey("noun") && suffixesHashStatic.get("noun").containsKey("2")) {
            suffixes2 = suffixesHashStatic.get("noun").get("2").get(lastchar);
        }
        if (suffixesHashStatic.containsKey("noun") && suffixesHashStatic.get("noun").containsKey("3")) {
            suffixes3 = suffixesHashStatic.get("noun").get("3").get(lastchar);
        }
        int i = 0;
        while (i < particlesStatic.size()) {
            if (word.endsWith(particlesStatic.get(i))) {
                word = word.replaceAll(String.valueOf(particlesStatic.get(i)) + "$", "");
                break;
            }
            ++i;
        }
        i = 0;
        while (suffixes1 != null && i < suffixes1.size()) {
            if (word.endsWith((String)suffixes1.get(i))) {
                endsuffixes.add((String)suffixes1.get(i));
            }
            ++i;
        }
        i = 0;
        while (suffixes2 != null && i < suffixes2.size()) {
            if (word.endsWith((String)suffixes2.get(i))) {
                endsuffixes.add((String)suffixes2.get(i));
            }
            ++i;
        }
        i = 0;
        while (suffixes3 != null && i < suffixes3.size()) {
            if (word.endsWith((String)suffixes3.get(i))) {
                endsuffixes.add((String)suffixes3.get(i));
            }
            ++i;
        }
        if (endsuffixes.size() == 0) {
            return false;
        }
        return !endsuffixes.contains("\u093e") && !endsuffixes.contains("\u0940") && !endsuffixes.contains("\u0947") || endsuffixes.size() != 1;
    }

    public static String getSuffix(String word) {
        int l = word.length();
        String lastchar = word.substring(l - 1);
        Vector<Object> suffixes1 = new Vector();
        Vector<Object> suffixes2 = new Vector();
        Vector<Object> suffixes3 = new Vector();
        Vector<Object> suffixes4 = new Vector();
        Vector<Object> suffixes5 = new Vector();
        Vector<Object> suffixes6 = new Vector();
        Vector<String> endsuffixes = new Vector<String>();
        if (suffixesHashStatic.containsKey("noun") && suffixesHashStatic.get("noun").containsKey("1")) {
            suffixes1 = suffixesHashStatic.get("noun").get("1").get(lastchar);
        }
        if (suffixesHashStatic.containsKey("noun") && suffixesHashStatic.get("noun").containsKey("2")) {
            suffixes2 = suffixesHashStatic.get("noun").get("2").get(lastchar);
        }
        if (suffixesHashStatic.containsKey("noun") && suffixesHashStatic.get("noun").containsKey("3")) {
            suffixes3 = suffixesHashStatic.get("noun").get("3").get(lastchar);
        }
        if (suffixesHashStatic.containsKey("verb") && suffixesHashStatic.get("noun").containsKey("1")) {
            suffixes4 = suffixesHashStatic.get("verb").get("1").get(lastchar);
        }
        if (suffixesHashStatic.containsKey("verb") && suffixesHashStatic.get("noun").containsKey("2")) {
            suffixes5 = suffixesHashStatic.get("verb").get("2").get(lastchar);
        }
        if (suffixesHashStatic.containsKey("verb") && suffixesHashStatic.get("noun").containsKey("3")) {
            suffixes6 = suffixesHashStatic.get("verb").get("3").get(lastchar);
        }
        int i = 0;
        while (i < particlesStatic.size()) {
            if (word.endsWith(particlesStatic.get(i))) {
                word = word.replaceAll(String.valueOf(particlesStatic.get(i)) + "$", "");
                break;
            }
            ++i;
        }
        i = 0;
        while (suffixes1 != null && i < suffixes1.size()) {
            if (word.endsWith((String)suffixes1.get(i))) {
                endsuffixes.add((String)suffixes1.get(i));
            }
            ++i;
        }
        i = 0;
        while (suffixes2 != null && i < suffixes2.size()) {
            if (word.endsWith((String)suffixes2.get(i))) {
                endsuffixes.add((String)suffixes2.get(i));
            }
            ++i;
        }
        i = 0;
        while (suffixes3 != null && i < suffixes3.size()) {
            if (word.endsWith((String)suffixes3.get(i))) {
                endsuffixes.add((String)suffixes3.get(i));
            }
            ++i;
        }
        i = 0;
        while (suffixes4 != null && i < suffixes4.size()) {
            if (word.endsWith((String)suffixes4.get(i))) {
                endsuffixes.add((String)suffixes4.get(i));
            }
            ++i;
        }
        i = 0;
        while (suffixes5 != null && i < suffixes5.size()) {
            if (word.endsWith((String)suffixes5.get(i))) {
                endsuffixes.add((String)suffixes5.get(i));
            }
            ++i;
        }
        i = 0;
        while (suffixes6 != null && i < suffixes6.size()) {
            if (word.endsWith((String)suffixes6.get(i))) {
                endsuffixes.add((String)suffixes6.get(i));
            }
            ++i;
        }
        if (endsuffixes.size() == 0) {
            return null;
        }
        if ((endsuffixes.contains("\u093e") || endsuffixes.contains("\u0940") || endsuffixes.contains("\u0947")) && endsuffixes.size() == 1) {
            return null;
        }
        int maxlen = 0;
        String maxSuff = "";
        int z = 0;
        while (z < endsuffixes.size()) {
            if (((String)endsuffixes.get(z)).length() > maxlen) {
                maxlen = ((String)endsuffixes.get(z)).length();
                maxSuff = (String)endsuffixes.get(z);
            }
            ++z;
        }
        if (maxSuff.equals("\u093e") || maxSuff.equals("\u0940") || maxSuff.equals("\u0947")) {
            return null;
        }
        String tempword = word;
        if ((tempword = tempword.replaceAll(String.valueOf(maxSuff) + "$", "")).length() <= 1) {
            return null;
        }
        return maxSuff;
    }

    public static int getSuffixIndex(String suffix) {
        return suffixesList.indexOf(suffix);
    }

    public Vector<StemmerRuleResult> checkForNounSuffixes(String token) {
        Vector<StemmerRuleResult> retval = new Vector<StemmerRuleResult>();
        token = token.trim();
        LinkedList<String> SuffList = new LinkedList<String>();
        String maxSuff = "";
        int iter = 0;
        boolean flag = false;
        while (!flag) {
            int i;
            if (iter == 0) {
                maxSuff = "";
                i = 0;
                while (i < this.NounSuffList.size()) {
                    if (token.endsWith(this.NounSuffList.get(i).trim()) && this.SuffPriority.get(i).trim().equals("p") && this.NounSuffList.get(i).trim().length() > maxSuff.length()) {
                        maxSuff = this.NounSuffList.get(i).trim();
                    }
                    ++i;
                }
                if (maxSuff != "") {
                    if ((token = token.replaceAll(String.valueOf(maxSuff) + "$", "")).endsWith("\u094d")) {
                        token = token.concat(maxSuff);
                    } else if (token.length() <= 2) {
                        token = token.concat(maxSuff);
                    } else {
                        SuffList.add(maxSuff);
                    }
                }
            } else if (iter == 1) {
                maxSuff = "";
                i = 0;
                while (i < this.NounSuffList.size()) {
                    if (token.endsWith(this.NounSuffList.get(i).trim()) && !this.SuffPriority.get(i).trim().equals("p") && this.NounSuffList.get(i).trim().length() > maxSuff.length()) {
                        maxSuff = this.NounSuffList.get(i).trim();
                    }
                    ++i;
                }
                if (maxSuff != "") {
                    token = token.replaceAll(String.valueOf(maxSuff) + "$", "");
                    if (maxSuff.equals("\u0924") && !token.endsWith("\u093e")) {
                        token = String.valueOf(token) + "\u0924";
                        flag = true;
                    } else if (token.endsWith("\u094d")) {
                        token = token.concat(maxSuff);
                        flag = true;
                    } else if (token.length() <= 2) {
                        token = token.concat(maxSuff);
                        flag = true;
                    } else {
                        SuffList.add(maxSuff);
                    }
                } else {
                    flag = true;
                }
            } else {
                maxSuff = "";
                i = 0;
                while (i < this.NounSuffList.size()) {
                    if (token.endsWith(this.NounSuffList.get(i).trim()) && this.SuffPriority.get(i).trim().equals("3") && this.NounSuffList.get(i).trim().length() > maxSuff.length()) {
                        maxSuff = this.NounSuffList.get(i).trim();
                    }
                    ++i;
                }
                if (maxSuff != "") {
                    if ((token = token.replaceAll(String.valueOf(maxSuff) + "$", "")).endsWith("\u094d")) {
                        token = token.concat(maxSuff);
                        flag = true;
                    } else if (token.length() <= 2) {
                        token = token.concat(maxSuff);
                        flag = true;
                    } else {
                        SuffList.add(maxSuff);
                    }
                } else {
                    flag = true;
                }
            }
            ++iter;
        }
        if (SuffList.size() != 0 && this.SuffPriority.get(this.NounSuffList.indexOf(((String)SuffList.getLast()).trim())).trim().equals("2")) {
            String tmp = ((String)SuffList.getLast()).trim();
            SuffList.removeLast();
            token = token.concat(tmp);
        }
        String token1 = "";
        String ud = "";
        if (SuffList.size() != 0) {
            if (token.endsWith("\u094d\u092f\u093e".trim())) {
                token = token.replaceAll("\u094d\u092f\u093e$", "\u093e");
                ud = "\u094d\u092f\u093e";
            } else if (token.endsWith("\u094d\u092f\u093e\u0902".trim())) {
                token = token.replaceAll("\u094d\u092f\u093e\u0902$", "\u093e");
                ud = "\u094d\u092f\u093e\u0902";
            } else if (token.endsWith("\u093e")) {
                token1 = token.replaceAll("\u093e$", "");
                retval.add(new StemmerRuleResult(token1, "ppppp", "noun", ud, SuffList));
                ud = "\u093e";
            } else if (token.endsWith("\u093e\u0902")) {
                token = token.replaceAll("\u093e\u0902$", "");
                ud = "\u093e\u0902";
            } else if (token.endsWith("\u0902")) {
                token = token.replaceAll("\u0902$", "");
                ud = "\u0902";
            }
        }
        if (SuffList.size() == 0) {
            retval.add(new StemmerRuleResult(token, "unknown", "unknown", "", ""));
        } else {
            retval.add(new StemmerRuleResult(token, "ppppp", "pnoun", ud, SuffList));
        }
        return retval;
    }

    public boolean hasIrregularRootForm(String token) {
        return this.irregularVerbHash.containsKey(token);
    }

    public Vector<Vector<String>> getRegularRootForm(String irregularForm) {
        Vector<Vector<String>> retval = new Vector<Vector<String>>();
        int i = 0;
        while (i < this.irregularVerbVector.size()) {
            if (this.irregularVerbVector.get(i).get(0).trim().equals(irregularForm)) {
                retval.add(this.irregularVerbVector.get(i));
            }
            ++i;
        }
        return retval;
    }

    public Vector<String[]> checkDerivationalMorphology(String token) {
        Vector<String[]> retVal = new Vector<String[]>();
        Set<String> suffixes = this.derivationalMorphologyRuleHash.keySet();
        for (String currentSuffix : suffixes) {
            if (!token.endsWith(currentSuffix)) continue;
            String root = token.replaceAll(String.valueOf(currentSuffix) + "$", "");
            HashMap<String, Vector<String>> rootCatToNewCatsHash = this.derivationalMorphologyRuleHash.get(currentSuffix);
            Set<String> rootCategories = rootCatToNewCatsHash.keySet();
            Iterator<String> rootCategoriesIter = rootCategories.iterator();
            String[] properties = new String[3];
            while (rootCategoriesIter.hasNext()) {
                String currentRootCategory = rootCategoriesIter.next();
                Vector<String> newCategoriesVector = rootCatToNewCatsHash.get(currentRootCategory);
                int i = 0;
                while (i < newCategoriesVector.size()) {
                    properties[0] = root;
                    properties[1] = currentRootCategory;
                    properties[2] = newCategoriesVector.get(i);
                    retVal.add(properties);
                    ++i;
                }
            }
        }
        if (retVal.size() == 0) {
            retVal = null;
        }
        return retVal;
    }

    public Set<String> getCategories() {
        return this.suffixesHash.keySet();
    }

    public Vector<String> getSpellingVariations(String token) {
        Vector<String> retVal = new Vector<String>();
        Set<String> chars = this.spellingVariationRuleHash.keySet();
        for (String currentChar : chars) {
            if (!token.contains(currentChar)) continue;
            retVal.add(token.replaceAll(currentChar, this.spellingVariationRuleHash.get(currentChar)));
        }
        if (retVal.size() == 0) {
            retVal = null;
        }
        return retVal;
    }

    public static void main(String[] args) {
        ConfigReader.read(args[0].trim());
        StemmerRuleReader ob = new StemmerRuleReader();
        ob.populate();
        String tmp = "\u0938\u0915/ \u0942\u0901\u0917\u093e, \u0942\u0901\u0917\u0940, \u0947\u0902\u0917\u0947,\u0917\u0947, \u094b\u0917\u0940, \u0947\u0917\u093e, \u0947\u0917\u0940, \u0947\u0902\u0917\u0940, \u094b\u0902\u0917\u0940";
        String word = "\u0932\u0917\u093e\u0928\u093e";
        if (word.endsWith("\u093e")) {
            System.out.println("Failed... " + word);
        } else {
            System.out.println("Working... " + word);
        }
        String test = "";
        if (test.isEmpty()) {
            System.out.println("Working...");
        } else {
            System.out.println("Failed...");
        }
    }
}

