/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import gnu.trove.TIntArrayList;
import iitb.ugm.Clique;
import iitb.ugm.MinFillEvalMetric;
import iitb.ugm.UDGraph;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDGraphImpl
implements UDGraph {
    private int numNodes;
    private int numEdges;
    ArrayList<TIntArrayList> adjList;
    ArrayList<BitSet> adjMatrix;

    public UDGraphImpl(int numNodes) {
        assert (numNodes > 0);
        this.numNodes = numNodes;
        this.numEdges = 0;
        this.adjList = new ArrayList();
        this.adjMatrix = new ArrayList();
        int i = 0;
        while (i < numNodes) {
            this.adjList.add(new TIntArrayList());
            this.adjMatrix.add(new BitSet(numNodes));
            ++i;
        }
    }

    public UDGraphImpl(UDGraph graph) {
        this(graph.getNumNodes());
        int i = 0;
        while (i < this.numNodes) {
            int j = 0;
            while (j < this.numNodes) {
                if (graph.isAdj(i, j)) {
                    this.addEdge(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int getNumNodes() {
        return this.numNodes;
    }

    @Override
    public int getNumEdges() {
        return this.numEdges;
    }

    @Override
    public boolean isAdj(int u, int v) {
        return this.adjMatrix.get(u).get(v);
    }

    @Override
    public void addEdge(int u, int v) {
        if (this.adjMatrix.get(u).get(v)) {
            return;
        }
        this.adjMatrix.get(u).set(v);
        this.adjMatrix.get(v).set(u);
        this.adjList.get(u).add(v);
        this.adjList.get(v).add(u);
        ++this.numEdges;
    }

    @Override
    public TIntArrayList getNeighbours(int u) {
        return this.adjList.get(u);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(UnDirected) nV = " + this.numNodes + ", nE = " + this.numEdges + "\n");
        int i = 0;
        while (i < this.numNodes) {
            sb.append(String.valueOf(i) + " :");
            TIntArrayList ni = this.getNeighbours(i);
            int j = 0;
            while (j < ni.size()) {
                sb.append(" " + ni.get(j));
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static Vector<Vector<Integer>> getConnectedComponents(UDGraph graph) {
        HashMap<Integer, Integer> componentMapping = new HashMap<Integer, Integer>();
        int cmptNum = 0;
        int vertex = 0;
        while (vertex < graph.getNumNodes()) {
            if (!componentMapping.containsKey(vertex)) {
                UDGraphImpl._DFS(graph, vertex, componentMapping, cmptNum++);
            }
            ++vertex;
        }
        Vector<Vector<Integer>> connectedComponents = new Vector<Vector<Integer>>();
        int i = 0;
        while (i < cmptNum) {
            connectedComponents.add(new Vector());
            ++i;
        }
        for (int vertex2 : componentMapping.keySet()) {
            connectedComponents.get(componentMapping.get(vertex2)).add(vertex2);
        }
        return connectedComponents;
    }

    private static void _DFS(UDGraph graph, int vertex, HashMap<Integer, Integer> componentMapping, int cmptNum) {
        componentMapping.put(vertex, cmptNum);
        TIntArrayList nbrs = graph.getNeighbours(vertex);
        int i = 0;
        while (i < nbrs.size()) {
            int nbr = nbrs.get(i);
            if (!componentMapping.containsKey(nbr)) {
                UDGraphImpl._DFS(graph, nbr, componentMapping, cmptNum);
            }
            ++i;
        }
    }

    public static int triangulate(UDGraph graph, int[] elim, MinFillEvalMetric metric) {
        int ntri = 0;
        int nv = graph.getNumNodes();
        boolean[] isMarked = new boolean[nv];
        int i = 0;
        while (i < nv) {
            int mini = -1;
            double minic = Double.MAX_VALUE;
            int j = 0;
            while (j < nv) {
                double cj;
                if (!isMarked[j] && (cj = metric.cost(j, graph, isMarked)) <= minic) {
                    minic = cj;
                    mini = j;
                }
                ++j;
            }
            if (elim != null) {
                elim[mini] = i;
            }
            isMarked[mini] = true;
            TIntArrayList nmini = graph.getNeighbours(mini);
            int j2 = 0;
            while (j2 < nmini.size()) {
                int k = j2 + 1;
                while (k < nmini.size()) {
                    int u = nmini.get(j2);
                    int v = nmini.get(k);
                    if (!(isMarked[u] || isMarked[v] || graph.isAdj(u, v))) {
                        graph.addEdge(nmini.get(j2), nmini.get(k));
                        ++ntri;
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        return ntri;
    }

    public static Vector<Clique> findCliques(UDGraph g) {
        Vector<Clique> c = new Vector<Clique>();
        Vector pi = new Vector();
        int nv = g.getNumNodes();
        boolean[] isMarked = new boolean[nv];
        int[] cost = new int[nv];
        int[] vv = new int[nv];
        int i = 0;
        while (i < nv) {
            int maxc = Integer.MIN_VALUE;
            int maxi = -1;
            int j = 0;
            while (j < nv) {
                if (!isMarked[j] && cost[j] >= maxc) {
                    maxi = j;
                    maxc = cost[j];
                }
                ++j;
            }
            isMarked[maxi] = true;
            vv[i] = maxi;
            TIntArrayList in = g.getNeighbours(maxi);
            Vector<Integer> nc = new Vector<Integer>();
            int j2 = 0;
            while (j2 < in.size()) {
                int v = in.get(j2);
                if (isMarked[v]) {
                    nc.add(v);
                } else {
                    int n = v;
                    cost[n] = cost[n] + 1;
                }
                ++j2;
            }
            nc.add(maxi);
            pi.add(i, nc);
            ++i;
        }
        i = 0;
        while (i < nv) {
            if (i == nv - 1 || ((Vector)pi.get(i + 1)).size() < ((Vector)pi.get(i)).size() + 1) {
                c.add(new Clique((Vector)pi.get(i)));
            }
            ++i;
        }
        i = 0;
        while (i < c.size()) {
            isMarked[i] = false;
            ++i;
        }
        i = 0;
        while (i < c.size()) {
            Clique ci = (Clique)c.get(i);
            int j = 0;
            while (j < c.size()) {
                if (j != i && !isMarked[j] && ((Clique)c.get(j)).contains(ci)) {
                    isMarked[i] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        Vector<Clique> finalc = new Vector<Clique>();
        i = 0;
        while (i < c.size()) {
            if (!isMarked[i]) {
                finalc.add((Clique)c.get(i));
            }
            ++i;
        }
        return finalc;
    }

    @Override
    public void removeEdge(int node1, int node2) {
        if (this.isAdj(node1, node2)) {
            this.adjList.get(node1).remove(this.adjList.get(node1).indexOf(node2));
            this.adjList.get(node2).remove(this.adjList.get(node2).indexOf(node1));
            this.adjMatrix.get(node1).clear(node2);
            this.adjMatrix.get(node2).clear(node1);
        }
    }
}

