/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.newstemmer;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.lexicon.WordProperties;
import iitb.cfilt.cpost.lexicon.Wordlist;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzer;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleReader;
import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import iitb.cfilt.cpost.newstemmer.StemmerRuleReader;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class Stemmer {
    static boolean mmAtStemmer = true;
    static boolean useStemDictionary = false;
    static boolean populated;
    static boolean useNounList;
    public static HashMap<String, StemmedToken> stemDictionary;
    public static StemmerRuleReader stemmerRuleReader;
    public static Stemmer stemObj;

    static {
        useNounList = false;
    }

    public static Stemmer getInstance(String lang, String config, String baseDir) {
        if (stemObj == null) {
            stemObj = new Stemmer(lang, config, baseDir);
            return stemObj;
        }
        return stemObj;
    }

    public Stemmer() {
        if (populated) {
            return;
        }
        System.out.println("************Resource Reading********");
        boolean fileFound = true;
        try {
            ObjectInputStream oin = new ObjectInputStream(new FileInputStream(ConfigReader.get("Stemmer.stemDictionary")));
            stemDictionary = (HashMap)oin.readObject();
        }
        catch (FileNotFoundException e) {
            fileFound = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (!fileFound || !useStemDictionary) {
            stemDictionary = new HashMap();
        }
        Wordlist.populate();
        stemmerRuleReader = new StemmerRuleReader();
        stemmerRuleReader.populate();
        populated = true;
    }

    public Stemmer(String lang, String config, String baseDir) {
        ConfigReader.read(config);
        Wordlist.populate(baseDir);
        stemmerRuleReader = new StemmerRuleReader();
        stemmerRuleReader.populate(baseDir);
        useNounList = Boolean.parseBoolean(ConfigReader.get("NewStemmer.useNounList"));
    }

    static void writeStemDictionary() {
        try {
            ObjectOutputStream oout = new ObjectOutputStream(new FileOutputStream(ConfigReader.get("Stemmer.stemDictionary")));
            oout.writeObject(stemDictionary);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Vector<StemmedToken> stem(Vector<String> tokens) {
        Vector<StemmedToken> retVal = new Vector<StemmedToken>(tokens.size());
        int i = 0;
        while (i < tokens.size()) {
            StemmedToken currentStemmedToken = this.stem(tokens.get(i));
            if (currentStemmedToken != null) {
                retVal.add(currentStemmedToken);
            }
            ++i;
        }
        if (retVal.size() == 0) {
            retVal = null;
        }
        return retVal;
    }

    public StemmedToken stem(String token) {
        Vector<String> spellingVariationsVector;
        boolean isNumber = token.matches("[0-9]+");
        if (isNumber) {
            StemmedToken retVal = new StemmedToken(token);
            StemmerRuleResult srr = new StemmerRuleResult(token, "cardinal", "cardinal", "", "");
            retVal.addStemmerOutput(srr);
            return retVal;
        }
        StemmedToken retVal = this.stem2(token);
        if (retVal.getStemmedOutputs().size() > 0 && retVal.getStemmedOutputs().get(0).getCategory().trim().equals("unknown") && (spellingVariationsVector = stemmerRuleReader.getSpellingVariations(token)) != null) {
            int i = 0;
            while (i < spellingVariationsVector.size()) {
                String currentSpellingVariation = spellingVariationsVector.get(i);
                StemmedToken st = this.stem1(currentSpellingVariation);
                if (!st.getStemmedOutputs().get(0).getCategory().trim().equals("unknown")) {
                    retVal.resetStemmedOutputs();
                    retVal.addAllStemmerOutputs(st.getStemmedOutputs());
                }
                ++i;
            }
        }
        return retVal;
    }

    public StemmedToken stem2(String token) {
        Vector<StemmerRuleResult> lexItems;
        int p;
        StemmedToken retVal = null;
        retVal = new StemmedToken(token);
        String temp_token = token;
        boolean flag = false;
        if (token.contains("-") && token.length() > 1 && (p = token.indexOf(45)) != 0) {
            token = token.substring(0, p);
            flag = true;
        }
        if ((lexItems = this.checkInLexicon(token)) != null) {
            retVal.addAllStemmerOutputs(lexItems);
        }
        Set<String> categories = stemmerRuleReader.getCategories();
        for (String cat : categories) {
            int i;
            Vector<StemmerRuleResult> srrv = stemmerRuleReader.applySuffixRules(token, cat);
            if (!srrv.isEmpty()) {
                i = 0;
                while (i < srrv.size()) {
                    if (!retVal.getStemmedOutputs().contains(srrv.get(i))) {
                        retVal.addStemmerOutput(srrv.get(i));
                    }
                    ++i;
                }
            }
            if (!(srrv = stemmerRuleReader.applySRR(token, cat)).isEmpty()) {
                i = 0;
                while (i < srrv.size()) {
                    if (!retVal.getStemmedOutputs().contains(srrv.get(i))) {
                        retVal.addStemmerOutput(srrv.get(i));
                    }
                    ++i;
                }
            }
            if ((srrv = stemmerRuleReader.applyIrregularVerbMapping(token, cat)).isEmpty()) continue;
            i = 0;
            while (i < srrv.size()) {
                if (!retVal.getStemmedOutputs().contains(srrv.get(i))) {
                    retVal.addStemmerOutput(srrv.get(i));
                }
                ++i;
            }
        }
        if (retVal.getStemmedOutputs().size() == 0) {
            if (!useNounList) {
                StemmerRuleResult srr = new StemmerRuleResult(token, "unknown", "unknown", "", "");
                retVal.addStemmerOutput(srr);
            } else {
                Vector<StemmerRuleResult> srrv = stemmerRuleReader.checkForNounSuffixes(token);
                retVal.addAllStemmerOutputs(srrv);
            }
        }
        retVal.sortResults();
        if (flag) {
            retVal.setToken(temp_token);
        }
        return retVal;
    }

    public StemmedToken stem1(String token) {
        Vector<StemmerRuleResult> srrv;
        int p;
        String temp_token = token;
        boolean flag = false;
        if (token.contains("-") && token.length() > 1 && (p = token.indexOf(45)) != 0) {
            token = token.substring(0, p);
            flag = true;
        }
        StemmedToken retVal = null;
        retVal = new StemmedToken(token);
        StemmerRuleResult specialCharacterResult = stemmerRuleReader.applySpecialCharacterRulesOn(token);
        if (specialCharacterResult != null) {
            retVal.addStemmerOutput(specialCharacterResult);
            return retVal;
        }
        Vector<StemmerRuleResult> lexItems = this.checkInLexicon(token);
        if (lexItems != null) {
            retVal.addAllStemmerOutputs(lexItems);
        }
        String firstchar = token.substring(0, 1);
        Set<String> categories = stemmerRuleReader.getCategories();
        for (String cat : categories) {
            srrv = stemmerRuleReader.removeCharamSuffix(token, cat);
            if (srrv != null) {
                retVal.addAllStemmerOutputs(srrv);
                continue;
            }
            srrv = stemmerRuleReader.applySRRs(token, cat);
            int it = 0;
            while (it < srrv.size()) {
                stemmerRuleReader.valid(srrv.get(it), cat);
                ++it;
            }
            if (srrv.size() <= 0) continue;
            retVal.addAllStemmerOutputs(srrv);
        }
        String particleRemovedToken = stemmerRuleReader.removeParticle(token);
        if (!particleRemovedToken.equals(token)) {
            Vector<StemmerRuleResult> lexItemsnew = this.checkInLexicon(particleRemovedToken);
            if (lexItemsnew != null) {
                int z = 0;
                while (z < lexItemsnew.size()) {
                    retVal.addStemmerOutput(lexItemsnew.get(z));
                    ++z;
                }
            }
            for (String cat : categories) {
                if (cat.equals("particle")) continue;
                Vector<StemmerRuleResult> srrv2 = stemmerRuleReader.removeCharamSuffix(particleRemovedToken, cat);
                if (srrv2 != null) {
                    retVal.addAllStemmerOutputs(srrv2);
                    continue;
                }
                srrv2 = stemmerRuleReader.applySRRs(particleRemovedToken, cat);
                if (srrv2 == null) continue;
                retVal.addAllStemmerOutputs(srrv2);
            }
        }
        if (retVal.getStemmedOutputs().size() == 0) {
            if (!useNounList) {
                StemmerRuleResult srr = new StemmerRuleResult(token, "unknown", "unknown", "", "");
                retVal.addStemmerOutput(srr);
            } else {
                srrv = stemmerRuleReader.checkForNounSuffixes(token);
                retVal.addAllStemmerOutputs(srrv);
            }
        }
        retVal.sortResults();
        if (flag) {
            retVal.setToken(temp_token);
        }
        return retVal;
    }

    private Vector<StemmerRuleResult> checkInLexicon(String token) {
        Vector<String[]> derivationalMorphologyOutput;
        Vector<StemmerRuleResult> retVal = new Vector<StemmerRuleResult>();
        Vector<WordProperties> tokenProperties = Wordlist.searchWordlistFor(token);
        if (tokenProperties != null) {
            int i = 0;
            while (i < tokenProperties.size()) {
                WordProperties tokenProperty = tokenProperties.get(i);
                StemmerRuleResult srresult = new StemmerRuleResult(token, tokenProperty.getParadigm(), tokenProperty.getCategory(), "", "");
                if (!retVal.contains(srresult)) {
                    retVal.add(srresult);
                }
                ++i;
            }
        }
        if (retVal.size() == 0 && (derivationalMorphologyOutput = stemmerRuleReader.checkDerivationalMorphology(token)) != null) {
            int i = 0;
            while (i < derivationalMorphologyOutput.size()) {
                String[] properties = derivationalMorphologyOutput.get(i);
                String derivedRoot = properties[0];
                String derivedRootCategory = properties[1];
                String derivedNewCategory = properties[2];
                Vector<WordProperties> derivedRootWordProperties = Wordlist.searchWordlistFor(derivedRoot);
                if (derivedRootWordProperties != null) {
                    int j = 0;
                    while (j < derivedRootWordProperties.size()) {
                        StemmerRuleResult srresult;
                        WordProperties dwp = derivedRootWordProperties.get(j);
                        if (dwp.getCategory().equals(derivedRootCategory) && !retVal.contains(srresult = new StemmerRuleResult(derivedRoot, "", derivedNewCategory, "", ""))) {
                            retVal.add(srresult);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (retVal.size() == 0) {
            retVal = null;
        }
        return retVal;
    }

    public static void main(String[] args) {
        ConfigReader.read(args[0]);
        Stemmer stemmer = new Stemmer();
        MorphologicalAnalyzerRuleReader MAR = new MorphologicalAnalyzerRuleReader();
        MorphologicalAnalyzer ma = new MorphologicalAnalyzer();
        String sentence = "\u092e\u093f\u0932\u0928\u0947";
        if (sentence.contains("\u093f\u092f\u093e")) {
            System.out.println("working..");
        }
        String[] words = sentence.split(" ");
        int i = 0;
        while (i < words.length) {
            StemmedToken stemmedToken = stemmer.stem(words[i]);
            System.out.println(stemmedToken.getStemmedOutputs().toString());
            MorphologicallyAnalyzedToken mat = ma.analyze(stemmedToken, MAR);
            System.out.println(mat.getAmbiguityScheme());
            ++i;
        }
    }
}

