/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.ma;

import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleResult;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.util.HashSet;
import java.util.Vector;

public class MorphologicallyAnalyzedToken {
    private StemmedToken stemmedToken;
    private Vector<MorphologicalAnalyzerRuleResult> morphologicalAnalyzerOutputs;
    boolean isTagFixed;
    private HashSet<String> Flags;
    private Integer AS;
    private int lwflag = 0;

    public MorphologicallyAnalyzedToken(StemmedToken stemmedToken, Vector<MorphologicalAnalyzerRuleResult> morphologicalAnalyzerOutputs) {
        this.stemmedToken = stemmedToken;
        this.morphologicalAnalyzerOutputs = morphologicalAnalyzerOutputs;
        this.isTagFixed = false;
    }

    public MorphologicallyAnalyzedToken(StemmedToken stemmedToken) {
        this.stemmedToken = stemmedToken;
        this.isTagFixed = false;
        this.morphologicalAnalyzerOutputs = new Vector();
    }

    public void setLWFlag(int f) {
        this.lwflag = f;
    }

    public int getLWFlag() {
        return this.lwflag;
    }

    public void setAS(Integer asID) {
        this.AS = new Integer(asID);
    }

    public Integer getAS() {
        return this.AS;
    }

    public void setFlags(HashSet flgs) {
        this.Flags = flgs;
    }

    public HashSet getFlags() {
        return this.Flags;
    }

    public boolean isTagFixed() {
        return this.isTagFixed;
    }

    public String getToken() {
        return this.stemmedToken.getToken();
    }

    public Vector<StemmerRuleResult> getStemmedOutputs() {
        return this.stemmedToken.getStemmedOutputs();
    }

    public Vector<MorphologicalAnalyzerRuleResult> getMorphologicalAnalyzerOutputs() {
        return this.morphologicalAnalyzerOutputs;
    }

    public boolean addMorphologicalAnalyzerOutput(MorphologicalAnalyzerRuleResult marr) {
        StemmerRuleResult srrtemp = new StemmerRuleResult(this.stemmedToken.getToken(), marr.getParadigm(), marr.getCategory(), marr.getUltimateDeletion(), marr.getSuffixList());
        this.stemmedToken.addStemmerOutput(srrtemp);
        return this.morphologicalAnalyzerOutputs.add(marr);
    }

    public boolean addAllMorphologicalAnalyzerOutputs(Vector<MorphologicalAnalyzerRuleResult> marrv) {
        return this.morphologicalAnalyzerOutputs.addAll(marrv);
    }

    public String getCategoryString() {
        String retVal = "";
        HashSet<String> retSet = new HashSet<String>();
        int i = 0;
        while (i < this.morphologicalAnalyzerOutputs.size()) {
            retSet.add(this.morphologicalAnalyzerOutputs.get(i).getCategory());
            ++i;
        }
        for (String currentCategory : retSet) {
            retVal = String.valueOf(retVal) + currentCategory + "*";
        }
        return retVal;
    }

    public void resetMorphologicalAnalyzerOutputs() {
        this.stemmedToken.resetStemmedOutputs();
        this.morphologicalAnalyzerOutputs = new Vector();
    }

    public void fixTag() {
        this.isTagFixed = true;
    }

    public String getAmbiguityScheme() {
        return this.stemmedToken.getAmbiguityScheme();
    }
}

