/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.ma;

import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.util.HashMap;
import java.util.LinkedList;

public class MorphologicalAnalyzerRuleResult
extends StemmerRuleResult {
    private String analysis;
    private HashMap<String, String> features = new HashMap();

    public MorphologicalAnalyzerRuleResult(String root, String paradigm, String ultimateDeletion, LinkedList<String> suffixList) {
        super(root, paradigm, ultimateDeletion, suffixList);
    }

    public MorphologicalAnalyzerRuleResult(String root, String paradigm, String category, String ultimateDeletion, LinkedList<String> suffixList) {
        super(root, paradigm, category, ultimateDeletion, suffixList);
    }

    public MorphologicalAnalyzerRuleResult(StemmerRuleResult srresult) {
        super(srresult.getRoot(), srresult.getParadigm(), srresult.getCategory(), srresult.getUltimateDeletion(), srresult.getSuffixList());
    }

    public MorphologicalAnalyzerRuleResult(StemmerRuleResult srresult, String analysis) {
        super(srresult.getRoot(), srresult.getParadigm(), srresult.getCategory(), srresult.getUltimateDeletion(), srresult.getSuffixList());
        this.setAnalysis(analysis);
    }

    public MorphologicalAnalyzerRuleResult(String root, String paradigm, String category, String ultimateDeletion, LinkedList<String> suffixList, String analysis) {
        super(root, paradigm, category, ultimateDeletion, suffixList);
        this.analysis = analysis;
        String[] fets = analysis.split(",");
        int i = 0;
        while (i < fets.length) {
            String[] fet = fets[i].split(":");
            this.features.put(fet[0], fet[1]);
            ++i;
        }
    }

    public void setProperties(String root, String paradigm, String category, String ultimateDeletion, LinkedList<String> suffixList, String analysis) {
        this.setRoot(root);
        this.setCategory(category);
        this.setParadigm(paradigm);
        this.setSuffixList(suffixList);
        this.analysis = analysis;
        if (analysis != "") {
            String[] fets = analysis.split(",");
            int i = 0;
            while (i < fets.length) {
                String[] fet = fets[i].split(":");
                this.features.put(fet[0], fet[1]);
                ++i;
            }
        }
    }

    public void setAnalysis(String analysis) {
        if (analysis != "") {
            this.analysis = analysis;
            String[] fets = analysis.split(",");
            int i = 0;
            while (i < fets.length) {
                String[] fet = fets[i].split(":");
                this.features.put(fet[0], fet[1]);
                ++i;
            }
        }
    }

    public void setFeature(String key, String value) {
        this.features.put(key, value);
    }

    public String getAnalysisString() {
        return this.analysis;
    }

    public HashMap getAnalysis() {
        return this.features;
    }

    public String getFeature(String featureKey) {
        if (this.features.containsKey(featureKey)) {
            return this.features.get(featureKey);
        }
        return null;
    }

    @Override
    public String toString() {
        String retVal = null;
        retVal = "Root : " + this.getRoot() + " Paradigm : " + this.getParadigm() + " Category : " + this.getCategory() + " Analysis : " + this.getAnalysis() + " }";
        retVal = retVal.substring(0, retVal.length() - 1);
        return retVal;
    }

    public String getSuffixType() {
        String analysis;
        String suffixType = "";
        if (this.getCategory().trim().startsWith("verb") && (analysis = this.getAnalysisString() != null ? this.getAnalysisString().trim() : "") != null && analysis.contains("Type:")) {
            int index = analysis.lastIndexOf("Type:");
            analysis = analysis.substring(index);
            suffixType = analysis.substring(5);
        }
        return suffixType;
    }
}

