/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.crfpp;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.UTFWriter;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzer;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleReader;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleResult;
import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import iitb.cfilt.cpost.newstemmer.Stemmer;
import iitb.cfilt.cpost.newstemmer.StemmerRuleReader;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import iitb.cfilt.cpost.vgi.VerbGroup7;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class FileFormer {
    private static Stemmer stemmer;
    private static MorphologicalAnalyzer ma;
    private static MorphologicalAnalyzerRuleReader MAR;
    private static VerbGroup7 vg;
    public static Vector<String> categories;
    public static Vector<String> tagcats;
    public static Vector<String> distinctTags;
    private static boolean NNFlag;
    private static boolean VGI;

    static {
        NNFlag = true;
        VGI = true;
    }

    public static void CreateFile(String inFile, String outFile, String flag, String flagVGI, String stemmer_output, String morphological, String tags) {
        try {
            String morpho_file = String.valueOf(outFile) + "_morpho";
            String stemmer_file = String.valueOf(outFile) + "_stemmer";
            File file_stemmer = new File(stemmer_file);
            if (file_stemmer.exists()) {
                file_stemmer.delete();
                file_stemmer = new File(stemmer_file);
            }
            UTFWriter ob_stemmer = new UTFWriter(file_stemmer);
            File file_morpho = new File(morpho_file);
            if (file_morpho.exists()) {
                file_morpho.delete();
                file_morpho = new File(morpho_file);
            }
            UTFWriter ob_morpho = new UTFWriter(file_morpho);
            file_stemmer.createNewFile();
            file_morpho.createNewFile();
            if (flag.equalsIgnoreCase("true")) {
                NNFlag = true;
            } else if (flag.equalsIgnoreCase("false")) {
                NNFlag = false;
            }
            if (flagVGI.equalsIgnoreCase("true")) {
                VGI = true;
            } else if (flagVGI.equalsIgnoreCase("false")) {
                VGI = false;
            }
            String tagFile = ConfigReader.get("CRF.tagfile");
            distinctTags = new Vector();
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tagFile), "UTF8"));
            String line = "";
            while ((line = bf.readLine()) != null) {
                String new_line;
                String[] vals = line.split(" ");
                StringBuilder sb = new StringBuilder();
                String[] stringArray = vals;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String s = stringArray[n];
                    if (s.trim().length() > 0) {
                        sb.append(s).append(" ");
                    }
                    ++n;
                }
                line = new_line = sb.toString().trim();
                distinctTags.add(line.trim());
            }
            bf.close();
            categories = new Vector();
            tagcats = new Vector();
            String tagCatMapFile = ConfigReader.get("HMM.tagCat");
            bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tagCatMapFile), "UTF8"));
            line = "";
            while ((line = bf.readLine()) != null) {
                String[] temp = line.split("-");
                categories.add(temp[1].trim());
                tagcats.add(temp[0].trim());
            }
            bf.close();
            File outfile = new File(outFile);
            if (outfile.exists()) {
                outfile.delete();
                outfile = new File(outFile);
            }
            UTFWriter ob = new UTFWriter(outfile);
            float rVaux = 0.0f;
            float pVaux = 0.0f;
            float nVaux = 0.0f;
            float rVm = 0.0f;
            float pVm = 0.0f;
            float nVm = 0.0f;
            bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF8"));
            line = "";
            boolean XCcnt = false;
            HashMap<String, StemmedToken> stemmerResultsHash = new HashMap<String, StemmedToken>();
            Vector<String> tokens = new Vector<String>();
            while ((line = bf.readLine()) != null) {
                if (line.length() == 0) continue;
                Vector<String> words = new Vector<String>();
                Vector<String> labels = new Vector<String>();
                String[] taggedWords = line.split("\\]");
                Vector<MorphologicallyAnalyzedToken> matv = new Vector<MorphologicallyAnalyzedToken>();
                Vector<StemmedToken> stv = new Vector<StemmedToken>();
                int i = 0;
                while (i < taggedWords.length) {
                    if (taggedWords[i].contains("_")) {
                        StemmedToken st;
                        String[] taggedWordComponents = taggedWords[i].split("_\\[");
                        String token = taggedWordComponents[0].trim() != "" ? taggedWordComponents[0].trim() : ".";
                        String temptag = taggedWordComponents[1].trim();
                        if (NNFlag) {
                            if (temptag.equals("NNC") || temptag.equals("NNP") || temptag.equals("NNPC") || temptag.equals("XC")) {
                                temptag = "NN";
                            } else if (temptag.equals("JJC")) {
                                temptag = "JJ";
                            }
                        } else if (temptag.equals("NNPC")) {
                            temptag = "NNP";
                        } else if (temptag.equals("NNC")) {
                            temptag = "NN";
                        } else if (temptag.equals("JJC")) {
                            temptag = "JJ";
                        }
                        if (stemmerResultsHash.keySet().contains(token)) {
                            st = (StemmedToken)stemmerResultsHash.get(token);
                        } else {
                            st = stemmer.stem(token);
                            stemmerResultsHash.put(token, st);
                            if (stemmer_output.equals("true") && !token.equals(".")) {
                                ob_stemmer.writeUTF("\nToken = " + st.getToken() + "\n");
                                ob_stemmer.writeUTF(String.valueOf(st.getStemmedOutputs().toString()) + "\n");
                            }
                        }
                        stv.add(st);
                        for (StemmerRuleResult temp : st.getStemmedOutputs()) {
                            if (temp.getSuffixList().indexOf(temp.getUltimateDeletion()) != -1) continue;
                            temp.getSuffixList().add(temp.getUltimateDeletion());
                        }
                        MorphologicallyAnalyzedToken mat = ma.analyze(st, MAR);
                        matv.add(mat);
                        Vector<StemmerRuleResult> strv = st.getStemmedOutputs();
                        Vector<MorphologicalAnalyzerRuleResult> marv = mat.getMorphologicalAnalyzerOutputs();
                        HashSet<String> cats = new HashSet<String>();
                        int z = 0;
                        while (z < strv.size()) {
                            cats.add(strv.get(z).getCategory().trim());
                            ++z;
                        }
                        words.add(token);
                        labels.add(temptag);
                    }
                    ++i;
                }
                Vector<MorphologicallyAnalyzedToken> vgitv = matv;
                int[] vga = vg.identifyVerbGroups1(matv);
                int i2 = 0;
                while (i2 < vgitv.size()) {
                    Vector<String> Categories = new Vector<String>();
                    boolean mf = false;
                    if (morphological.equals("true") && !vgitv.get(i2).getToken().equals(".") && !tokens.contains(vgitv.get(i2).getToken())) {
                        ob_morpho.writeUTF("\nToken = " + vgitv.get(i2).getToken() + " + ");
                        tokens.add(vgitv.get(i2).getToken());
                        mf = true;
                    }
                    int j = 0;
                    while (j < vgitv.get(i2).getMorphologicalAnalyzerOutputs().size()) {
                        if (morphological.equals("true") && !vgitv.get(i2).getToken().equals(".") && mf) {
                            ob_morpho.writeUTF("Analysis String = " + vgitv.get(i2).getMorphologicalAnalyzerOutputs().get(j).getAnalysisString() + " + ");
                        }
                        if (!Categories.contains(vgitv.get(i2).getMorphologicalAnalyzerOutputs().get(j).getCategory().trim())) {
                            Categories.add(vgitv.get(i2).getMorphologicalAnalyzerOutputs().get(j).getCategory().trim());
                        }
                        ++j;
                    }
                    Collections.sort(Categories);
                    String AS = "";
                    Vector<Integer> catFlags = new Vector<Integer>();
                    int j2 = 0;
                    while (j2 < categories.size()) {
                        catFlags.add(0);
                        ++j2;
                    }
                    if (((String)labels.get(i2)).equals("VAUX")) {
                        rVaux += 1.0f;
                    }
                    if (((String)labels.get(i2)).equals("VM")) {
                        rVm += 1.0f;
                    }
                    if (VGI && vga[i2] > 0) {
                        if (vga[i2] > 1) {
                            if (vga[i2] == 100) {
                                AS = "noun";
                                catFlags.set(categories.indexOf("noun"), 1);
                            } else {
                                pVaux += 1.0f;
                                if (((String)labels.get(i2)).equals("VAUX")) {
                                    nVaux += 1.0f;
                                }
                                AS = "verb_aux";
                                catFlags.set(categories.indexOf("verb_aux"), 1);
                            }
                        } else {
                            pVm += 1.0f;
                            if (((String)labels.get(i2)).equals("VM")) {
                                nVm += 1.0f;
                            }
                            AS = "verb";
                            catFlags.set(categories.indexOf("verb"), 1);
                        }
                    } else {
                        j2 = 0;
                        while (j2 < Categories.size()) {
                            AS = String.valueOf(AS) + (String)Categories.get(j2) + "*";
                            catFlags.set(categories.indexOf(Categories.get(j2)), 1);
                            ++j2;
                        }
                        int l = AS.length();
                        AS = AS.substring(0, l - 1);
                    }
                    String cats = "";
                    int j3 = 0;
                    while (j3 < categories.size()) {
                        cats = String.valueOf(cats) + Integer.toString((Integer)catFlags.get(j3)) + "\t";
                        ++j3;
                    }
                    String suffix = StemmerRuleReader.getSuffix((String)words.get(i2));
                    if (suffix == null) {
                        suffix = "NoSuff";
                    }
                    String curr_word = (String)words.get(i2);
                    int len = curr_word.length();
                    String s1 = "No";
                    String s2 = "No";
                    String s3 = "No";
                    String s4 = "No";
                    String p1 = "No";
                    String p2 = "No";
                    String p3 = "No";
                    String p4 = "No";
                    if (len >= 4) {
                        s1 = curr_word.substring(len - 1);
                        s2 = curr_word.substring(len - 2);
                        s3 = curr_word.substring(len - 3);
                        s4 = curr_word.substring(len - 4);
                        p1 = curr_word.substring(0, 1);
                        p2 = curr_word.substring(0, 2);
                        p3 = curr_word.substring(0, 3);
                        p4 = curr_word.substring(0, 4);
                    } else if (len >= 3) {
                        s1 = curr_word.substring(len - 1);
                        s2 = curr_word.substring(len - 2);
                        s3 = curr_word.substring(len - 3);
                        p1 = curr_word.substring(0, 1);
                        p2 = curr_word.substring(0, 2);
                        p3 = curr_word.substring(0, 3);
                    } else if (len >= 2) {
                        s1 = curr_word.substring(len - 1);
                        s2 = curr_word.substring(len - 2);
                        p1 = curr_word.substring(0, 1);
                        p2 = curr_word.substring(0, 2);
                    } else if (len >= 1) {
                        s1 = curr_word.substring(len - 1);
                        p1 = curr_word.substring(0, 1);
                    }
                    String combined_suffixes = String.valueOf(s1) + "\t" + s2 + "\t" + s3 + "\t" + s4 + "\t";
                    String combined_prefixes = String.valueOf(p1) + "\t" + p2 + "\t" + p3 + "\t" + p4 + "\t";
                    ob.writeUTF(String.valueOf((String)words.get(i2)) + "\t" + AS + "\t" + cats + suffix + "\t" + combined_suffixes + Integer.toString(len) + "\t" + combined_prefixes + (String)labels.get(i2) + "\n");
                    ++i2;
                }
                ob.writeUTF("\n");
            }
            System.out.println("VM Precision : " + nVm / pVm + ", VM Recall : " + nVm / rVm + ", Vaux Precision : " + nVaux / pVaux + ", Vaux Recall : " + nVaux / rVaux);
            System.out.println("Done!");
            bf.close();
            ob.close();
            ob_morpho.close();
            ob_stemmer.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ConfigReader.read(args[0]);
        stemmer = new Stemmer();
        MAR = new MorphologicalAnalyzerRuleReader();
        ma = new MorphologicalAnalyzer();
        vg = new VerbGroup7();
        if (args.length == 8) {
            FileFormer.CreateFile(args[1].trim(), args[2].trim(), args[3].trim(), args[4].trim(), args[5].trim(), args[6].trim(), args[7].trim());
        } else if (args.length == 6 || args.length == 5) {
            FileFormer.CreateFile(args[1].trim(), args[2].trim(), args[3].trim(), args[4].trim(), "false", "false", "false");
        } else {
            System.out.println("Error : number of arguments");
        }
    }
}

