/*
 * Decompiled with CFR 0.152.
 */
package iitb.Utils;

import java.util.BitSet;

public class Counters {
    int[] cnts = null;
    int[] maxVals = null;
    BitSet fixedVals;

    public Counters(int numCtrs, int maxVal) {
        this(numCtrs, new int[numCtrs]);
        int i = 0;
        while (i < this.maxVals.length) {
            this.maxVals[i++] = maxVal;
        }
    }

    public Counters(int numCtrs, int[] maxVals) {
        this.cnts = new int[numCtrs];
        this.fixedVals = new BitSet(numCtrs + 1);
        this.maxVals = maxVals;
    }

    public void fix(int index, int val) {
        this.cnts[index] = val;
        this.fixedVals.set(index);
    }

    public void clear() {
        int i = 0;
        while (i < this.cnts.length) {
            this.cnts[i++] = 0;
        }
        this.fixedVals.clear();
    }

    public void init(int[] maxVal) {
        this.clear();
        int i = 0;
        while (i < this.maxVals.length) {
            if (maxVal[i] == 0) {
                this.cnts[this.cnts.length - 1] = maxVal[this.cnts.length - 1];
            }
            this.maxVals[i] = maxVal[i];
            ++i;
        }
    }

    public void init(int maxVal) {
        this.clear();
        int i = 0;
        while (i < this.maxVals.length) {
            this.maxVals[i] = maxVal;
            ++i;
        }
    }

    int nextNonFixed(int i) {
        return this.fixedVals.nextClearBit(i);
    }

    public boolean isFixed(int index) {
        return this.fixedVals.get(index);
    }

    public boolean advance() {
        int i = 0;
        while (i < this.cnts.length) {
            if ((i = this.nextNonFixed(i)) < this.cnts.length) {
                int n = i;
                this.cnts[n] = this.cnts[n] + 1;
                if (this.cnts[i] < this.maxVals[i]) {
                    return true;
                }
                if (i < this.cnts.length - 1) {
                    this.cnts[i] = 0;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean done() {
        return this.cnts[this.cnts.length - 1] >= this.maxVals[this.cnts.length - 1];
    }

    public int get(int index) {
        return this.cnts[index];
    }

    public int value(int endIndex, int startIndex) {
        int val = 0;
        int i = endIndex;
        while (i >= startIndex) {
            val = val * this.maxVals[i] + this.cnts[i];
            --i;
        }
        return val;
    }

    public int value() {
        return this.value(this.cnts.length - 1, 0);
    }

    public void arrayCopy(int endIndex, int startIndex, int[] arr) {
        int i = endIndex;
        while (i >= startIndex) {
            arr[i - startIndex] = this.cnts[i];
            --i;
        }
    }
}

