/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.ma;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MorphologicalAnalyzerRuleReader {
    private String stemAnalysisFile = ConfigReader.get("MA.stemAnalysisFile");
    private String suffixAnalysisFile = ConfigReader.get("MA.suffixAnalysisFile");
    private String stemFlagFile = ConfigReader.get("MA.stemFlagFile");
    private String suffixFlagFile = ConfigReader.get("MA.suffixFlagFile");
    private PrintStream pout = null;
    private HashMap stemHash;
    private HashMap suffHash;
    private HashMap stemFlagHash;
    private HashMap suffFlagHash;

    public MorphologicalAnalyzerRuleReader() {
        this.createRules();
        this.createFlagMap();
    }

    private void createFlagMap() {
        this.createStemFlagMap();
        this.createSuffFlagMap();
    }

    private void createStemFlagMap() {
        this.stemFlagHash = new HashMap();
        BufferedReader sBuff = null;
        try {
            sBuff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.stemFlagFile), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String line = "";
        String paradigm = "";
        while (line != null) {
            Vector stemFlag;
            HashMap stemPar;
            Pattern pSpace;
            String[] lineComponents;
            Matcher mIgnore;
            Matcher mEmpty;
            Pattern pEmpty = Pattern.compile("^\\s*$");
            Pattern pIgnore = Pattern.compile("^\\/\\/");
            do {
                try {
                    line = sBuff.readLine();
                }
                catch (IOException e2) {
                    System.out.println("Some file error:" + this.stemFlagFile);
                }
                if (line == null) break;
                line = line.trim();
                mIgnore = pEmpty.matcher(line);
            } while ((mEmpty = pIgnore.matcher(line)).find() || mIgnore.find());
            if (line == null) continue;
            if (line.startsWith("#")) {
                paradigm = line.substring(1);
                continue;
            }
            Pattern pTab = Pattern.compile("\t");
            Matcher mTab = pTab.matcher(line);
            if (mTab.find()) {
                line = mTab.replaceAll(" ");
            }
            if ((lineComponents = (pSpace = Pattern.compile(" ")).split(line)).length != 2) continue;
            String stem = lineComponents[0].trim();
            String flag = lineComponents[1].trim();
            if (this.stemFlagHash.containsKey(stem)) {
                stemPar = (HashMap)this.stemFlagHash.get(stem);
                if (stemPar.containsKey(paradigm)) {
                    stemFlag = (Vector)stemPar.get(paradigm);
                    stemFlag.add(flag);
                    stemPar.put(paradigm, stemFlag);
                    this.stemFlagHash.put(stem, stemPar);
                    continue;
                }
                stemFlag = new Vector();
                stemFlag.add(flag);
                stemPar.put(paradigm, stemFlag);
                this.stemFlagHash.put(stem, stemPar);
                continue;
            }
            stemPar = new HashMap();
            stemFlag = new Vector();
            stemFlag.add(flag);
            stemPar.put(paradigm, stemFlag);
            this.stemFlagHash.put(stem, stemPar);
        }
    }

    private void createSuffFlagMap() {
        this.suffFlagHash = new HashMap();
        BufferedReader sBuff = null;
        try {
            sBuff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.suffixFlagFile), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String line = "";
        String category = "";
        while (line != null) {
            Vector suffFlag;
            HashMap suffPar;
            Pattern pSpace;
            String[] lineComponents;
            Matcher mIgnore;
            Matcher mEmpty;
            Pattern pEmpty = Pattern.compile("^\\s*$");
            Pattern pIgnore = Pattern.compile("^\\/\\/");
            do {
                try {
                    line = sBuff.readLine();
                }
                catch (IOException e2) {
                    System.out.println("Some file error:" + this.suffixFlagFile);
                }
                if (line == null) break;
                line = line.trim();
                mIgnore = pEmpty.matcher(line);
            } while ((mEmpty = pIgnore.matcher(line)).find() || mIgnore.find());
            if (line == null) continue;
            if (line.startsWith("#")) {
                category = line.substring(1);
                continue;
            }
            Pattern pTab = Pattern.compile("\t");
            Matcher mTab = pTab.matcher(line);
            if (mTab.find()) {
                line = mTab.replaceAll(" ");
            }
            if ((lineComponents = (pSpace = Pattern.compile(" ")).split(line)).length != 2) continue;
            String suff = lineComponents[0].trim();
            String flag = lineComponents[1].trim();
            if (this.suffFlagHash.containsKey(suff)) {
                suffPar = (HashMap)this.suffFlagHash.get(suff);
                if (suffPar.containsKey(category)) {
                    suffFlag = (Vector)suffPar.get(category);
                    suffFlag.add(flag);
                    suffPar.put(category, suffFlag);
                    this.suffFlagHash.put(suff, suffPar);
                    continue;
                }
                suffFlag = new Vector();
                suffFlag.add(flag);
                suffPar.put(category, suffFlag);
                this.suffFlagHash.put(suff, suffPar);
                continue;
            }
            suffPar = new HashMap();
            suffFlag = new Vector();
            suffFlag.add(flag);
            suffPar.put(category, suffFlag);
            this.suffFlagHash.put(suff, suffPar);
        }
    }

    private void createRules() {
        try {
            this.pout = new PrintStream((OutputStream)System.out, true, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.stemHash = new HashMap();
        BufferedReader sBuff = null;
        try {
            sBuff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.stemAnalysisFile), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String line = "";
        while (line != null) {
            Vector stemAna;
            HashMap stemPar;
            Matcher mIgnore;
            Matcher mEmpty;
            Pattern pEmpty = Pattern.compile("^\\s*$");
            Pattern pIgnore = Pattern.compile("^\\/\\/");
            do {
                try {
                    line = sBuff.readLine();
                }
                catch (IOException e2) {
                    System.out.println("Some file error:" + this.stemAnalysisFile);
                }
                if (line == null) break;
                line = line.trim();
                mIgnore = pEmpty.matcher(line);
            } while ((mEmpty = pIgnore.matcher(line)).find() || mIgnore.find());
            if (line == null) continue;
            line = line.replaceAll("\\t", " ");
            line = line.replaceAll("\\s+", " ");
            Pattern pComma = Pattern.compile(",");
            Pattern pSpace = Pattern.compile(" ");
            String[] stemLineComponents = pSpace.split(line);
            if (stemLineComponents.length != 3) continue;
            String paradigm = stemLineComponents[0].trim();
            String stem = stemLineComponents[1].trim();
            String analysis = stemLineComponents[2].trim();
            Matcher mComma = pComma.matcher(paradigm);
            paradigm = mComma.replaceAll("");
            mComma = pComma.matcher(stem);
            if (this.stemHash.containsKey(stem = mComma.replaceAll(""))) {
                stemPar = (HashMap)this.stemHash.get(stem);
                if (stemPar.containsKey(paradigm)) {
                    stemAna = (Vector)stemPar.get(paradigm);
                    stemAna.add(analysis);
                    stemPar.put(paradigm, stemAna);
                    this.stemHash.put(stem, stemPar);
                    continue;
                }
                stemAna = new Vector();
                stemAna.add(analysis);
                stemPar.put(paradigm, stemAna);
                this.stemHash.put(stem, stemPar);
                continue;
            }
            stemPar = new HashMap();
            stemAna = new Vector();
            stemAna.add(analysis);
            stemPar.put(paradigm, stemAna);
            this.stemHash.put(stem, stemPar);
        }
        this.suffHash = new HashMap();
        BufferedReader suffBuff = null;
        try {
            suffBuff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.suffixAnalysisFile), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String suffline = "";
        while (suffline != null) {
            Vector suffAna;
            HashMap suffPar;
            Matcher mComma;
            Matcher mIgnore;
            Matcher mEmpty;
            Pattern pEmpty = Pattern.compile("^\\s*$");
            Pattern pIgnore = Pattern.compile("^\\/\\/");
            do {
                try {
                    suffline = suffBuff.readLine();
                }
                catch (IOException e2) {
                    System.out.println("Some file error:" + this.suffixAnalysisFile);
                }
                if (suffline == null) break;
                suffline = suffline.trim();
                mIgnore = pEmpty.matcher(suffline);
            } while ((mEmpty = pIgnore.matcher(suffline)).find() || mIgnore.find());
            if (suffline == null) continue;
            Pattern pComma = Pattern.compile(",");
            Pattern pSpace = Pattern.compile(" ");
            String[] suffLineComponents = pComma.split(suffline);
            if (suffLineComponents.length == 0) continue;
            String paradigm = suffLineComponents[0].trim();
            String suff = suffLineComponents[1].trim();
            int i = 2;
            String analysis = "";
            while (i < suffLineComponents.length) {
                mComma = pComma.matcher(suffLineComponents[++i - 1]);
                String addOn = mComma.replaceAll("");
                Matcher mSpace = pSpace.matcher(addOn);
                addOn = mSpace.replaceAll("");
                analysis = String.valueOf(analysis) + "," + addOn.trim();
            }
            mComma = pComma.matcher(analysis);
            analysis = mComma.replaceFirst("");
            mComma = pComma.matcher(paradigm);
            paradigm = mComma.replaceAll("");
            mComma = pComma.matcher(suff);
            if (this.suffHash.containsKey(suff = mComma.replaceAll(""))) {
                suffPar = (HashMap)this.suffHash.get(suff);
                if (suffPar.containsKey(paradigm)) {
                    suffAna = (Vector)suffPar.get(paradigm);
                    suffAna.add(analysis);
                    suffPar.put(paradigm, suffAna);
                    this.suffHash.put(suff, suffPar);
                    continue;
                }
                suffAna = new Vector();
                suffAna.add(analysis);
                suffPar.put(paradigm, suffAna);
                this.suffHash.put(suff, suffPar);
                continue;
            }
            suffPar = new HashMap();
            suffAna = new Vector();
            suffAna.add(analysis);
            suffPar.put(paradigm, suffAna);
            this.suffHash.put(suff, suffPar);
        }
    }

    public Vector getSuffixAnalysis(String suffix, String paradigm) {
        PrintStream pout = null;
        try {
            pout = new PrintStream((OutputStream)System.out, true, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        suffix = "^" + suffix;
        Vector analysis = new Vector();
        for (String key : this.suffHash.keySet()) {
            int j;
            int i;
            Vector newAna;
            Vector tempAnalysis;
            HashMap parAna;
            if (key.startsWith("^")) {
                if (!suffix.concat("$").contains(key) || suffix.concat("$").contains(key.concat("$")) || !(parAna = (HashMap)this.suffHash.get(key)).containsKey(paradigm)) continue;
                tempAnalysis = (Vector)parAna.get(paradigm);
                newAna = new Vector();
                i = 0;
                while (i < analysis.size()) {
                    j = 0;
                    while (j < tempAnalysis.size()) {
                        pout.println("Bigger :" + analysis);
                        pout.println("Smaller :" + tempAnalysis);
                        newAna.add(((String)analysis.elementAt(i)).concat(",").concat((String)tempAnalysis.elementAt(j)));
                        ++j;
                    }
                    ++i;
                }
                if (newAna.isEmpty()) {
                    newAna = tempAnalysis;
                }
                analysis = newAna;
                continue;
            }
            if (!suffix.concat("$").contains(key) || suffix.concat("$").contains(key.concat("$")) || !(parAna = (HashMap)this.suffHash.get(key)).containsKey(paradigm)) continue;
            tempAnalysis = (Vector)parAna.get(paradigm);
            newAna = new Vector();
            i = 0;
            while (i < analysis.size()) {
                j = 0;
                while (j < tempAnalysis.size()) {
                    pout.println("Bigger :" + analysis);
                    pout.println("Smaller :" + tempAnalysis);
                    newAna.add(((String)analysis.elementAt(i)).concat(",").concat((String)tempAnalysis.elementAt(j)));
                    ++j;
                }
                ++i;
            }
            if (newAna.isEmpty()) {
                newAna = tempAnalysis;
            }
            analysis = newAna;
        }
        return analysis;
    }

    public Vector getStemAnalysis(String root, String paradigm) {
        HashMap parAna;
        Vector analysis = null;
        if (this.stemHash.containsKey(root) && (parAna = (HashMap)this.stemHash.get(root)).containsKey(paradigm)) {
            analysis = (Vector)parAna.get(paradigm);
        }
        return analysis;
    }

    public Vector<String> getStemFlag(String stem, String category) {
        Set stemKeys = this.stemFlagHash.keySet();
        Iterator sKItr = stemKeys.iterator();
        Vector f = null;
        while (sKItr.hasNext()) {
            HashMap parFlag;
            String hStem = (String)sKItr.next();
            if (!stem.contains(hStem) || !(parFlag = (HashMap)this.stemFlagHash.get(hStem)).containsKey(category)) continue;
            f = (Vector)parFlag.get(category);
        }
        return f;
    }

    public Vector<String> getSuffixFlag(String suffix, String category) {
        Set suffKeys = this.suffFlagHash.keySet();
        Iterator sKItr = suffKeys.iterator();
        Vector f = null;
        while (sKItr.hasNext()) {
            HashMap parFlag;
            String hSuffix = (String)sKItr.next();
            if (!suffix.contains(hSuffix) || !(parFlag = (HashMap)this.suffFlagHash.get(hSuffix)).containsKey(category)) continue;
            f = (Vector)parFlag.get(category);
        }
        return f;
    }

    public MorphologicallyAnalyzedToken analyse(StemmedToken sToken) {
        return null;
    }
}

