/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.ma;

import iitb.cfilt.cpost.logger.Logger;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleReader;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleResult;
import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class MorphologicalAnalyzer {
    public Vector<MorphologicallyAnalyzedToken> analyze(Vector<StemmedToken> tokens) {
        MorphologicalAnalyzerRuleReader MAR = new MorphologicalAnalyzerRuleReader();
        Vector<MorphologicallyAnalyzedToken> retVal = new Vector<MorphologicallyAnalyzedToken>();
        for (StemmedToken token : tokens) {
            MorphologicallyAnalyzedToken mat = this.analyze(token, MAR);
            if (mat == null) continue;
            retVal.add(mat);
        }
        if (retVal.size() == 0) {
            retVal = null;
        }
        return retVal;
    }

    public MorphologicallyAnalyzedToken analyze(StemmedToken token, MorphologicalAnalyzerRuleReader MAR) {
        MorphologicallyAnalyzedToken retVal = new MorphologicallyAnalyzedToken(token);
        Vector<MorphologicalAnalyzerRuleResult> marrv = new Vector<MorphologicalAnalyzerRuleResult>();
        Vector<String> flags = new Vector<String>();
        Vector<StemmerRuleResult> stemmerRuleResults = token.getStemmedOutputs();
        for (StemmerRuleResult currentStemmerRuleResult : stemmerRuleResults) {
            LinkedList<String> suffixList = currentStemmerRuleResult.getSuffixList();
            String root = currentStemmerRuleResult.getRoot();
            String paradigm = currentStemmerRuleResult.getParadigm();
            String category = currentStemmerRuleResult.getCategory();
            Vector<String> analysis = new Vector<String>();
            Iterator listItr = suffixList.iterator();
            if (suffixList.size() == 1) {
                analysis = MAR.getSuffixAnalysis("-", paradigm);
            }
            while (listItr.hasNext()) {
                String suffixString = (String)listItr.next();
                Vector tempAnalysis = MAR.getSuffixAnalysis(suffixString, paradigm);
                analysis = this.joinVector(tempAnalysis, analysis);
                Vector<String> f = MAR.getSuffixFlag(suffixString, category);
                if (f == null) continue;
                flags.addAll(f);
            }
            if (analysis.size() == 0 && suffixList.size() > 1) {
                analysis = MAR.getSuffixAnalysis("S", paradigm);
            }
            Vector rootAnalysis = MAR.getStemAnalysis(root, paradigm);
            Vector<String> stemflags = MAR.getStemFlag(root, category);
            if (stemflags != null) {
                flags.addAll(stemflags);
            }
            if (rootAnalysis != null) {
                analysis = this.joinVector(rootAnalysis, analysis);
            }
            if (!analysis.isEmpty()) {
                int i = 0;
                while (i < analysis.size()) {
                    String analysisString = analysis.elementAt(i);
                    marrv.add(new MorphologicalAnalyzerRuleResult(currentStemmerRuleResult, analysisString));
                    ++i;
                }
            }
            if (!analysis.isEmpty()) continue;
            marrv.add(new MorphologicalAnalyzerRuleResult(currentStemmerRuleResult));
        }
        retVal = new MorphologicallyAnalyzedToken(token, marrv);
        retVal.setFlags(new HashSet(flags));
        for (MorphologicalAnalyzerRuleResult marr : retVal.getMorphologicalAnalyzerOutputs()) {
            Logger.println(marr.toString());
        }
        return retVal;
    }

    private Vector<String> joinVector(Vector<String> v1, Vector<String> v2) {
        Vector<String> newAna = new Vector<String>();
        int i = 0;
        while (i < v1.size()) {
            int j = 0;
            while (j < v2.size()) {
                newAna.add(v1.elementAt(i).concat(",").concat(v2.elementAt(j)));
                ++j;
            }
            ++i;
        }
        if (newAna.isEmpty()) {
            newAna = v1.size() > 0 ? v1 : v2;
        }
        return newAna;
    }

    public synchronized Vector<MorphologicallyAnalyzedToken> analyzeStub(Vector<StemmedToken> stv) {
        Vector<MorphologicallyAnalyzedToken> retVal = new Vector<MorphologicallyAnalyzedToken>(stv.size());
        for (StemmedToken st : stv) {
            MorphologicallyAnalyzedToken mat = new MorphologicallyAnalyzedToken(st);
            Vector<StemmerRuleResult> srrv = st.getStemmedOutputs();
            for (StemmerRuleResult srresult : srrv) {
                StemmerRuleResult tmp = new StemmerRuleResult(srresult);
                mat.addMorphologicalAnalyzerOutput(new MorphologicalAnalyzerRuleResult(tmp));
            }
            if (mat == null) continue;
            retVal.add(mat);
        }
        if (retVal.size() == 0) {
            retVal = null;
        }
        return retVal;
    }
}

