/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.crfpp;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.UTFWriter;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import iitb.cfilt.cpost.newstemmer.Stemmer;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class AdvancedTester {
    private static Stemmer stemmer;
    public static Vector<String> distinctTags;
    public static Vector<String> categories;
    public static Vector<String> tagcats;

    public static int getTagNum(String tag) {
        return distinctTags.indexOf(tag);
    }

    public static String getNumTag(int tagnum) {
        return distinctTags.get(tagnum);
    }

    public static String catToTag(String category) {
        String ret = "";
        int pos = categories.indexOf(category);
        if (pos >= 0) {
            ret = tagcats.get(pos);
        }
        return ret;
    }

    public static void testAccuracy(String testfile, String resultfile) {
        int total = 0;
        int correct = 0;
        int searchSpaceErrors = 0;
        distinctTags = new Vector();
        categories = new Vector();
        tagcats = new Vector();
        try {
            int j;
            File outfile = new File(resultfile);
            if (outfile.exists()) {
                outfile.delete();
                outfile = new File(resultfile);
            }
            UTFWriter ob = new UTFWriter(outfile);
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ConfigReader.get("CRF.tagfile")), "UTF8"));
            String line = "";
            while ((line = bf.readLine()) != null) {
                distinctTags.add(line.trim());
            }
            bf.close();
            bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ConfigReader.get("HMM.tagCat")), "UTF8"));
            line = "";
            while ((line = bf.readLine()) != null) {
                String[] temp = line.split("-");
                categories.add(temp[1].trim());
                tagcats.add(temp[0].trim());
            }
            bf.close();
            int[][] confMatrix = new int[distinctTags.size()][distinctTags.size()];
            int i = 0;
            while (i < distinctTags.size()) {
                j = 0;
                while (j < distinctTags.size()) {
                    confMatrix[i][j] = 0;
                    ++j;
                }
                ++i;
            }
            bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(testfile), "UTF8"));
            line = "";
            while ((line = bf.readLine()) != null) {
                if (line.length() != 0) {
                    String[] cols = line.split("\t");
                    int l = cols.length;
                    String word = cols[0].trim();
                    String oldtag = cols[l - 2].trim();
                    String newtag = cols[l - 1].trim();
                    StemmedToken st = stemmer.stem(word);
                    Vector<StemmerRuleResult> srrv = st.getStemmedOutputs();
                    Vector<String> possibleTags = new Vector<String>();
                    if (!srrv.get(0).getCategory().trim().equals("unknown") && !newtag.equals("NNP")) {
                        int i2 = 0;
                        while (i2 < srrv.size()) {
                            possibleTags.add(AdvancedTester.catToTag(srrv.get(i2).getCategory().trim()));
                            ++i2;
                        }
                        if (possibleTags.indexOf(newtag) == -1) {
                            ++searchSpaceErrors;
                            System.out.println(String.valueOf(newtag) + " : " + possibleTags + " : " + word);
                            newtag = (String)possibleTags.get(0);
                        }
                    }
                    ++total;
                    if (newtag.equals(oldtag)) {
                        ++correct;
                        ob.writeUTF(String.valueOf(word) + " : " + newtag + "\n");
                        int[] nArray = confMatrix[AdvancedTester.getTagNum(oldtag)];
                        int n = AdvancedTester.getTagNum(oldtag);
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    ob.writeUTF(String.valueOf(word) + " : " + newtag + " Correct tag : " + oldtag + "\n");
                    int[] nArray = confMatrix[AdvancedTester.getTagNum(oldtag)];
                    int n = AdvancedTester.getTagNum(newtag);
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                ob.writeUTF("\n");
            }
            System.out.println("Total words : " + total);
            System.out.println("Correct words : " + correct);
            System.out.println("Search Space Errors : " + searchSpaceErrors);
            System.out.println("Accuracy : " + (double)correct * 100.0 / (double)total);
            System.out.println("\n");
            i = 0;
            while (i < distinctTags.size()) {
                System.out.print(String.valueOf(AdvancedTester.getNumTag(i)) + "\t");
                int incorrect = 0;
                int j2 = 0;
                while (j2 < distinctTags.size()) {
                    if (i != j2) {
                        incorrect += confMatrix[i][j2];
                    }
                    ++j2;
                }
                double accuracy = 100.0 * (double)confMatrix[i][i] / (double)(confMatrix[i][i] + incorrect);
                System.out.println("Correct:" + confMatrix[i][i] + "\tErrors:" + incorrect + "\tTotal:" + (confMatrix[i][i] + incorrect) + "\tAccuracy:" + accuracy);
                ++i;
            }
            System.out.println("\nConfusion Matrix :\n");
            i = 0;
            while (i < distinctTags.size()) {
                System.out.print(String.valueOf(AdvancedTester.getNumTag(i)) + "\t");
                j = 0;
                while (j < distinctTags.size()) {
                    if (confMatrix[i][j] != 0) {
                        System.out.print(String.valueOf(AdvancedTester.getNumTag(j)) + ":" + confMatrix[i][j] + " ");
                    }
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println("Done!");
            ob.close();
            bf.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ConfigReader.read(args[0].trim());
        stemmer = new Stemmer();
        AdvancedTester.testAccuracy(args[1].trim(), args[2].trim());
    }
}

