/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.UTFWriter;
import iitb.cfilt.cpost.lexicon.Wordlist;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzer;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleReader;
import iitb.cfilt.cpost.ma.MorphologicalAnalyzerRuleResult;
import iitb.cfilt.cpost.ma.MorphologicallyAnalyzedToken;
import iitb.cfilt.cpost.newstemmer.StemmedToken;
import iitb.cfilt.cpost.newstemmer.Stemmer;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

class MA {
    private static Stemmer stemmer;
    private static MorphologicalAnalyzer morphologicalAnalyzer;
    MorphologicalAnalyzerRuleReader MAR = new MorphologicalAnalyzerRuleReader();
    Vector<StemmedToken> stv;
    Vector<MorphologicallyAnalyzedToken> matv = new Vector();

    MA(String wlfile) {
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(wlfile), "UTF8"));
            String line = "";
            while ((line = bf.readLine()) != null) {
                StemmedToken tempStem = this.getST(line);
                for (StemmerRuleResult temp : tempStem.getStemmedOutputs()) {
                    if (temp.getSuffixList().indexOf(temp.getUltimateDeletion()) != -1) continue;
                    temp.getSuffixList().add(temp.getUltimateDeletion());
                }
                MorphologicallyAnalyzedToken mat = morphologicalAnalyzer.analyze(tempStem, this.MAR);
                this.matv.add(mat);
            }
            bf.close();
            String MAoutput = ConfigReader.get("MA.MAOutput");
            File outfile = new File(MAoutput);
            if (outfile.exists()) {
                outfile.delete();
                outfile = new File(MAoutput);
            }
            UTFWriter ob = new UTFWriter(outfile);
            int cnt = 1;
            for (MorphologicallyAnalyzedToken mat : this.matv) {
                String st = mat.getToken();
                System.out.println(String.valueOf(st) + " ");
                ob.writeUTF(st);
                ++cnt;
                ob.writeUTF("\n");
                Vector<StemmerRuleResult> strv = mat.getStemmedOutputs();
                Vector<MorphologicalAnalyzerRuleResult> mrv = mat.getMorphologicalAnalyzerOutputs();
                for (StemmerRuleResult str : strv) {
                    String root = str.getRoot();
                    ob.writeUTF("Root:");
                    ob.writeUTF(root);
                    ob.writeUTF("L:" + root.length());
                    ob.writeUTF(" Paradigm:");
                    ob.writeUTF(str.getParadigm());
                    ob.writeUTF(" Category:");
                    ob.writeUTF(str.getCategory());
                    if (str.getUltimateDeletion() != "") {
                        ob.writeUTF(" Ultimate Deletion:");
                        ob.writeUTF(str.getUltimateDeletion());
                    }
                    LinkedList<String> suffList = str.getSuffixList();
                    Iterator iterSuff = suffList.iterator();
                    ob.writeUTF("Length:");
                    ob.writeUTF(Integer.toString(suffList.size()));
                    while (iterSuff.hasNext()) {
                        ob.writeUTF(String.valueOf((String)iterSuff.next()) + ":");
                    }
                    ob.writeUTF("\n");
                }
                for (MorphologicalAnalyzerRuleResult mar : mrv) {
                    if (mar.getAnalysisString() == null) continue;
                    ob.writeUTF("Analysis:");
                    ob.writeUTF(mar.getAnalysisString());
                    ob.writeUTF("\n");
                }
                ob.writeUTF("\n");
            }
            System.out.println("cnt = " + cnt);
            ob.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    StemmedToken getST(String line) {
        String token = "";
        String root = "";
        String analysis = "";
        String suff = "";
        if (line.indexOf("\t") != -1) {
            token = line.substring(line.indexOf("\t") + 1);
        }
        StemmedToken retval = stemmer.stem(token);
        return retval;
    }

    String ConvertToSSF(String analysis) {
        analysis = analysis.replace(':', '=');
        analysis = analysis.replace(',', ' ');
        return analysis;
    }

    public static void initialize(String config) {
        ConfigReader.read(config);
        Wordlist.populate();
        stemmer = new Stemmer();
        System.out.println("SSSSSSSSSSSS");
        morphologicalAnalyzer = new MorphologicalAnalyzer();
        System.out.println("SSSSSSSSSSSS");
    }

    public static void main(String[] args) {
        MA.initialize(args[0]);
        MA obj = new MA(args[1]);
    }
}

