/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost;

import iitb.cfilt.cpost.UTFWriter;
import iitb.cfilt.cpost.lexicon.WordProperties;
import iitb.cfilt.cpost.lexicon.Wordlist;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class LexEntry
extends JPanel
implements ActionListener {
    JComponent lex;
    JLabel lblWord = new JLabel("Word");
    JLabel lblPar = new JLabel("Paradigm");
    JLabel lblCat = new JLabel("Category");
    JTextArea txtResult = new JTextArea("Search Result");
    JTextField txtWord = new JTextField();
    JButton btnLoad = new JButton("Load File");
    JTextField txtFile;
    JButton btnNext = new JButton("Next");
    JButton btnPrev = new JButton("Previous");
    JButton btnInitLex;
    JButton btnSearch;
    JButton btnJump = new JButton("Jump");
    JComboBox cmbCategory;
    JList lstParadigm;
    JButton btnParInit;
    JScrollPane scrl;
    JButton btnOutFile;
    JButton btnLex;
    JButton btnDone;
    String strWord;
    String strFile = "";
    String strLexFile;
    BufferedReader bf;
    BufferedReader bfp;
    File outFile;
    File lout;
    UTFWriter outLex;
    Vector<String> uwords;
    Vector<Vector<String>> paradigms;
    Vector<String> categories;
    int cnt = 0;

    public LexEntry() {
        this.btnInitLex = new JButton("Initialize Lexicon");
        this.btnSearch = new JButton("Search");
        this.cmbCategory = new JComboBox();
        this.lstParadigm = new JList();
        this.btnParInit = new JButton("Initialize Paradigms");
        this.scrl = new JScrollPane(this.lstParadigm);
        this.btnOutFile = new JButton("Select output file");
        this.btnLex = new JButton("Add to Lexicon");
        this.btnDone = new JButton("Done!");
        JTabbedPane tabbedPane = new JTabbedPane();
        ImageIcon icon = LexEntry.createImageIcon("");
        this.lex = this.makeTextPanel("");
        tabbedPane.addTab("Lexicon Entry", icon, this.lex, "Enter word in Lexicon");
        this.lblWord.setBounds(65, 15, 60, 20);
        this.lex.add(this.lblWord);
        this.txtWord.setBounds(25, 45, 115, 35);
        this.lex.add(this.txtWord);
        this.btnLoad.setBounds(255, 260, 100, 20);
        this.lex.add(this.btnLoad);
        this.btnLoad.addActionListener(this);
        this.btnNext.setBounds(65, 85, 70, 20);
        this.lex.add(this.btnNext);
        this.btnNext.addActionListener(this);
        this.btnPrev.setBounds(65, 115, 70, 20);
        this.lex.add(this.btnPrev);
        this.btnPrev.addActionListener(this);
        this.btnJump.setBounds(65, 145, 70, 20);
        this.lex.add(this.btnJump);
        this.btnJump.addActionListener(this);
        this.btnInitLex.setBounds(45, 300, 140, 20);
        this.lex.add(this.btnInitLex);
        this.btnInitLex.addActionListener(this);
        this.txtResult.setBounds(5, 180, 240, 50);
        this.lex.add(this.txtResult);
        this.btnSearch.setBounds(195, 140, 80, 20);
        this.lex.add(this.btnSearch);
        this.btnSearch.addActionListener(this);
        this.btnSearch.setVisible(false);
        this.lblCat.setBounds(210, 15, 60, 20);
        this.lex.add(this.lblCat);
        this.lblPar.setBounds(425, 15, 60, 20);
        this.lex.add(this.lblPar);
        this.cmbCategory.setBounds(180, 45, 175, 25);
        this.lex.add(this.cmbCategory);
        this.cmbCategory.addItem("Noun-M");
        this.cmbCategory.addItem("Noun-F");
        this.cmbCategory.addItem("Noun-N");
        this.cmbCategory.addItem("Proper Noun-M");
        this.cmbCategory.addItem("Proper Noun-F");
        this.cmbCategory.addItem("Proper Noun-N");
        this.cmbCategory.addItem("verb");
        this.cmbCategory.addItem("adjective");
        this.cmbCategory.addItem("adverb");
        this.cmbCategory.addItem("pronoun");
        this.cmbCategory.addItem("verb_aux");
        this.cmbCategory.setSelectedIndex(-1);
        this.cmbCategory.addActionListener(this);
        this.cmbCategory.setVisible(false);
        this.btnParInit.setBounds(400, 260, 160, 20);
        this.lex.add(this.btnParInit);
        this.btnParInit.addActionListener(this);
        this.btnLex.setBounds(550, 40, 160, 50);
        this.lex.add(this.btnLex);
        this.btnLex.addActionListener(this);
        this.btnDone.setBounds(625, 220, 100, 20);
        this.lex.add(this.btnDone);
        this.btnDone.addActionListener(this);
        this.scrl.setBounds(400, 45, 120, 200);
        this.lex.add(this.scrl);
        this.scrl.setVisible(false);
        this.lex.setPreferredSize(new Dimension(900, 340));
        this.lex.setLayout(null);
        this.add(tabbedPane);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int z;
        WordProperties wp;
        int z2;
        String result;
        Vector<WordProperties> temp;
        Object obj = ae.getSource();
        if (obj == this.btnLoad) {
            File file = this.getFileDialogOpen("");
            this.strFile = file.getPath();
            System.out.println("File selected is   " + this.strFile);
            this.uwords = new Vector();
            try {
                this.bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.strFile), "UTF8"));
                String line = "";
                while ((line = this.bf.readLine()) != null) {
                    line = line.trim();
                    this.uwords.add(line);
                }
                this.bf.close();
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
            this.strWord = this.uwords.get(this.cnt);
            this.txtWord.setText(this.strWord);
            ++this.cnt;
        }
        if (obj == this.btnNext) {
            if (this.cnt >= this.uwords.size() - 1) {
                try {
                    JOptionPane.showMessageDialog(this, "File entries over!", "Done!", 1);
                    this.cnt = 0;
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            } else {
                ++this.cnt;
                this.strWord = this.uwords.get(this.cnt);
                this.txtWord.setText(this.strWord);
                if (this.txtWord.getText().length() > 0) {
                    temp = Wordlist.searchWordlistFor(this.txtWord.getText());
                    result = "";
                    z2 = 0;
                    while (z2 < temp.size()) {
                        wp = temp.get(z2);
                        result = String.valueOf(result) + "Word = " + this.txtWord.getText() + ", Par = " + wp.getParadigm() + ", Cat = " + wp.getCategory() + "\n";
                        ++z2;
                    }
                    this.txtResult.setText(result);
                }
            }
        }
        if (obj == this.btnPrev) {
            if (this.cnt <= 0) {
                try {
                    JOptionPane.showMessageDialog(this, "File entries over!", "Done!", 1);
                    this.cnt = 0;
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            } else {
                --this.cnt;
                this.strWord = this.uwords.get(this.cnt);
                this.txtWord.setText(this.strWord);
                if (this.txtWord.getText().length() > 0) {
                    temp = Wordlist.searchWordlistFor(this.txtWord.getText());
                    result = "";
                    z2 = 0;
                    while (z2 < temp.size()) {
                        wp = temp.get(z2);
                        result = String.valueOf(result) + "Word = " + this.txtWord.getText() + ", Par = " + wp.getParadigm() + ", Cat = " + wp.getCategory() + "\r\n";
                        ++z2;
                    }
                    this.txtResult.setText(result);
                }
            }
        }
        if (obj == this.btnJump) {
            if (this.uwords.indexOf(this.txtWord.getText()) != -1) {
                this.cnt = this.uwords.indexOf(this.txtWord.getText());
                this.txtWord.setText(this.uwords.get(this.cnt));
            } else {
                try {
                    JOptionPane.showMessageDialog(this, "This word is not in the file!", "Error!", 0);
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            }
        }
        if (obj == this.cmbCategory && (z = this.categories.indexOf(this.cmbCategory.getSelectedItem().toString())) >= 0) {
            this.lstParadigm.setListData(this.paradigms.get(z));
        }
        if (obj == this.btnParInit) {
            this.paradigms = new Vector();
            this.categories = new Vector();
            File parFile = this.getFileDialogOpen("");
            String strParFile = parFile.getPath();
            Vector<String> temp2 = new Vector<String>();
            try {
                this.bfp = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(strParFile), "UTF8"));
                String line = "";
                while ((line = this.bfp.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) {
                        if (this.categories.size() >= 1) {
                            this.paradigms.add(temp2);
                        }
                        temp2 = new Vector();
                        this.categories.add(line.substring(1));
                        System.out.println("In Cat" + line.substring(1));
                        continue;
                    }
                    temp2.add(line);
                }
                this.paradigms.add(temp2);
                this.bfp.close();
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
            this.scrl.setVisible(true);
            this.cmbCategory.setVisible(true);
            this.btnParInit.setVisible(false);
        }
        if (obj == this.btnLex) {
            String cat = "";
            cat = this.cmbCategory.getSelectedItem().toString().startsWith("Noun") ? "noun" : (this.cmbCategory.getSelectedItem().toString().startsWith("Proper Noun") ? "pnoun" : (this.cmbCategory.getSelectedItem().toString().startsWith("pronoun") ? "pn" : this.cmbCategory.getSelectedItem().toString()));
            String lexEntry = "<" + this.txtWord.getText() + ">, <" + this.lstParadigm.getSelectedValue().toString() + ">, <" + cat + ">\n";
            Wordlist.hashLine(lexEntry);
            try {
                this.outLex.writeUTF(lexEntry);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
        if (obj == this.btnDone) {
            try {
                this.outLex.close();
                System.exit(0);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
        if (obj == this.btnInitLex) {
            try {
                this.strLexFile = this.getFileDialogOpen("").getAbsolutePath();
                Wordlist.populateFromFile(this.strLexFile);
                this.btnSearch.setVisible(true);
                this.btnInitLex.setVisible(false);
                this.lout = new File(this.strLexFile);
                this.outLex = new UTFWriter(this.lout);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
        if (obj == this.btnSearch) {
            if (this.txtWord.getText().length() > 0) {
                Vector<WordProperties> temp3 = Wordlist.searchWordlistFor(this.txtWord.getText());
                result = "";
                int z3 = 0;
                while (z3 < temp3.size()) {
                    wp = temp3.get(z3);
                    result = String.valueOf(result) + "Word = " + this.txtWord.getText() + ", Par = " + wp.getParadigm() + ", Cat = " + wp.getCategory() + "\n";
                    ++z3;
                }
                this.txtResult.setText(result);
            } else {
                JOptionPane.showMessageDialog(this, "No Word to search!", "Error!", 0);
            }
        }
    }

    protected File getFileDialogOpen(String filter) {
        JFrame frm = new JFrame("");
        FileDialog fd = new FileDialog((Frame)frm, "Select File", 0);
        fd.setFile(filter);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        File file = new File(String.valueOf(fd.getDirectory()) + fd.getFile());
        if (!file.canRead()) {
            return null;
        }
        return file;
    }

    protected JComponent makeTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.add(filler);
        return panel;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = LexEntry.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Lexicon Entry");
        frame.setDefaultCloseOperation(3);
        LexEntry newContentPane = new LexEntry();
        newContentPane.setOpaque(true);
        frame.getContentPane().add(new LexEntry());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LexEntry.createAndShowGUI();
            }
        });
    }
}

