/*
 * Decompiled with CFR 0.152.
 */
package jal.LONG;

import jal.LONG.BinaryOperator;
import jal.LONG.BinaryPredicate;
import jal.LONG.Generator;
import jal.LONG.Inspection;
import jal.LONG.Predicate;
import jal.LONG.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(long[] lArray, long[] lArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(lArray, n, lArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(long[] lArray, long[] lArray2, int n, int n2, int n3) {
        while (n < n2) {
            long l = lArray2[n3];
            lArray2[n3] = lArray[n];
            lArray[n] = l;
            ++n;
            ++n3;
        }
    }

    public static void transform(long[] lArray, long[] lArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            lArray2[n3++] = unaryOperator.apply(lArray[n++]);
        }
    }

    public static void transform(long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            lArray3[n4++] = binaryOperator.apply(lArray[n++], lArray2[n3++]);
        }
    }

    public static void replace(long[] lArray, int n, int n2, long l, long l2) {
        while (n < n2) {
            if (lArray[n] == l) {
                lArray[n] = l2;
            }
            ++n;
        }
    }

    public static void replace_if(long[] lArray, int n, int n2, Predicate predicate, long l) {
        while (n < n2) {
            if (predicate.apply(lArray[n])) {
                lArray[n] = l;
            }
            ++n;
        }
    }

    public static void replace_copy(long[] lArray, long[] lArray2, int n, int n2, int n3, long l, long l2) {
        while (n < n2) {
            long l3 = lArray[n++];
            long l4 = lArray2[n3++] = l3 == l ? l2 : l3;
        }
    }

    public static void replace_copy_if(long[] lArray, long[] lArray2, int n, int n2, int n3, Predicate predicate, long l) {
        while (n < n2) {
            long l2 = lArray[n++];
            long l3 = lArray2[n3++] = predicate.apply(l2) ? l : l2;
        }
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        while (n < n2) {
            lArray[n++] = l;
        }
    }

    public static void generate(long[] lArray, int n, int n2, Generator generator) {
        while (n < n2) {
            lArray[n++] = generator.apply();
        }
    }

    public static int remove_if(long[] lArray, int n, int n2, long l) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && lArray[n] != l) {
                continue;
            }
            while (n < --n2 && lArray[n2] == l) {
            }
            if (n >= n2) {
                return n;
            }
            lArray[n] = lArray[n2];
        }
    }

    public static int remove_if(long[] lArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(lArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(lArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            lArray[n] = lArray[n2];
        }
    }

    public static int stable_remove(long[] lArray, int n, int n2, long l) {
        n = Inspection.find(lArray, n, n2, l);
        int n3 = Inspection.find_not(lArray, n, n2, l);
        while (n3 < n2) {
            lArray[n++] = lArray[n3];
            ++n3;
            n3 = Inspection.find_not(lArray, n3, n2, l);
        }
        return n;
    }

    public static int stable_remove_if(long[] lArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(lArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(lArray, n, n2, predicate);
        while (n3 < n2) {
            lArray[n++] = lArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(lArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(long[] lArray, long[] lArray2, int n, int n2, int n3, long l) {
        while (n < n2) {
            long l2;
            if ((l2 = lArray[n++]) == l) continue;
            lArray2[n3++] = l2;
        }
        return n3;
    }

    public static int remove_copy_if(long[] lArray, long[] lArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            long l;
            if (predicate.apply(l = lArray[n++])) continue;
            lArray2[n3++] = l;
        }
        return n3;
    }

    public static int unique(long[] lArray, int n, int n2) {
        n = Inspection.adjacent_find(lArray, n, n2);
        return Modification.unique_copy(lArray, lArray, n, n2, n);
    }

    public static int unique(long[] lArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(lArray, n, n2, binaryPredicate);
        return Modification.unique_copy(lArray, lArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(long[] lArray, long[] lArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        lArray2[n3] = lArray[n];
        while (++n < n2) {
            if (lArray2[n3] == lArray[n]) continue;
            lArray2[++n3] = lArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(long[] lArray, long[] lArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        lArray2[n3] = lArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(lArray2[n3], lArray[n])) continue;
            lArray2[++n3] = lArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(long[] lArray, int n, int n2) {
        while (n < --n2) {
            long l = lArray[n];
            lArray[n++] = lArray[n2];
            lArray[n2] = l;
        }
    }

    public static void reverse_copy(long[] lArray, int n, int n2, int n3) {
        while (n2 > n) {
            lArray[n3++] = lArray[--n2];
        }
    }

    public static void reverse_copy(long[] lArray, long[] lArray2, int n, int n2, int n3) {
        while (n2 > n) {
            lArray2[n3++] = lArray[--n2];
        }
    }

    public static void rotate(long[] lArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(lArray, n, n2);
            Modification.reverse(lArray, n2, n3);
            Modification.reverse(lArray, n, n3);
        }
    }

    public static void rotate_copy(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4) {
        Modification.copy(lArray, lArray2, n2, n3, n4);
        Modification.copy(lArray, lArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(long[] lArray, int n, int n2, Random random) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random.nextInt()) % (n3 - n + 1);
            long l = lArray[n4];
            lArray[n4] = lArray[n3];
            lArray[n3] = l;
            ++n3;
        }
    }

    public static void random_shuffle(long[] lArray, int n, int n2) {
        Modification.random_shuffle(lArray, n, n2, default_RNG);
    }

    public static int partition(long[] lArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(lArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(lArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            long l = lArray[n];
            lArray[n] = lArray[n2];
            lArray[n2] = l;
        }
    }

    public static int stable_partition(long[] lArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(lArray, n, n3, predicate);
            int n5 = Modification.stable_partition(lArray, n3, n2, predicate);
            Modification.rotate(lArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(lArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

