/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import iitb.ugm.CliquePotential;
import iitb.ugm.Constraints;
import iitb.ugm.GraphicalModel;
import iitb.ugm.NodePotential;
import iitb.ugm.Potential;
import iitb.ugm.UDGraph;
import iitb.ugm.UDGraphImpl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDGM
extends GraphicalModel {
    protected UDGraph graph;
    protected NodePotential[] nodePotentials;
    protected int[] nodeArities;
    protected Potential defaultCliquePotential;
    protected Hashtable<Integer, Potential> cliquePotentials;
    protected int maxNodeArity;
    protected int maxCliqueSize;
    protected int bitsPerNode;
    protected int numOfNodes;
    protected boolean uniformArity;
    private Constraints constraints;

    public UDGM(Potential defCliquePotential, int numOfNodes, int uniformNodeArity, int cliqueSize) {
        this.init(new UDGraphImpl(numOfNodes), defCliquePotential, numOfNodes, uniformNodeArity, cliqueSize);
    }

    public UDGM(UDGraph graph, int uniformNodeArity, Potential defCliquePotential, int cliqueSize) {
        this.init(graph, defCliquePotential, graph.getNumNodes(), uniformNodeArity, cliqueSize);
    }

    void init(UDGraph graph, Potential defCliquePotential, int numOfNodes, int uniformNodeArity, int cliqueSize) {
        this.graph = graph;
        int bitsRequired = (int)Math.ceil(Math.log(numOfNodes + 1) / Math.log(2.0)) * cliqueSize;
        assert (bitsRequired <= 32);
        this.numOfNodes = numOfNodes;
        this.bitsPerNode = bitsRequired / cliqueSize;
        this.maxNodeArity = uniformNodeArity;
        this.uniformArity = true;
        this.maxCliqueSize = cliqueSize;
        this.defaultCliquePotential = defCliquePotential;
        this.nodeArities = new int[numOfNodes];
        int i = 0;
        while (i < this.nodeArities.length) {
            this.nodeArities[i] = uniformNodeArity;
            ++i;
        }
        this.nodePotentials = new NodePotential[numOfNodes];
        this.cliquePotentials = new Hashtable();
    }

    public UDGM(UDGraph graph, int[] nodeArities, Potential defaultPotential, int maxCliqueSize) {
        this.graph = graph;
        this.numOfNodes = graph.getNumNodes();
        int bitsRequired = (int)Math.ceil(Math.log(this.numOfNodes + 1) / Math.log(2.0)) * maxCliqueSize;
        assert (bitsRequired <= 32);
        this.bitsPerNode = bitsRequired / maxCliqueSize;
        this.defaultCliquePotential = defaultPotential;
        this.nodeArities = nodeArities;
        this.maxCliqueSize = maxCliqueSize;
        this.nodePotentials = new NodePotential[this.numOfNodes];
        this.cliquePotentials = new Hashtable();
    }

    public UDGM(int numNodes) {
        this(null, numNodes, 0, 1);
    }

    protected UDGM() {
    }

    @Override
    public double getNodePotential(int node, int label) {
        if (this.nodePotentials[node] != null) {
            return this.nodePotentials[node].getPotentialValue(label);
        }
        return 0.0;
    }

    public Integer getCliqueKey(int[] nodes) {
        assert (nodes.length <= this.maxCliqueSize);
        int key = 0;
        int i = 0;
        while (i < nodes.length) {
            key <<= this.bitsPerNode;
            key += nodes[i];
            ++i;
        }
        return key;
    }

    @Override
    public double getCliquePotential(int[] nodes, int[] labels) {
        int[][] cliques = new int[nodes.length][2];
        int i = 0;
        while (i < nodes.length) {
            cliques[i][0] = nodes[i];
            cliques[i][1] = labels[i];
            ++i;
        }
        Arrays.sort(cliques, new D2ArrayComparator(1));
        i = 0;
        while (i < nodes.length) {
            nodes[i] = cliques[i][0];
            labels[i] = cliques[i][1];
            ++i;
        }
        Integer key = this.getCliqueKey(nodes);
        if (this.cliquePotentials.containsKey(key)) {
            return this.cliquePotentials.get(key).getPotential(labels);
        }
        return this.defaultCliquePotential.getPotential(labels);
    }

    @Override
    public boolean compare(GraphicalModel agm) {
        return false;
    }

    @Override
    public void copyStruct(GraphicalModel agm) {
        this.numOfNodes = agm.getNumNodes();
        this.bitsPerNode = agm.getBitsPerNode();
        this.maxNodeArity = agm.getMaxArity();
        this.uniformArity = agm.isUniformArity();
        this.maxCliqueSize = agm.getMaxCliqueSize();
        this.defaultCliquePotential = agm.getDefaultCliquePotential();
        this.nodeArities = new int[this.numOfNodes];
        int i = 0;
        while (i < this.numOfNodes) {
            this.nodeArities[i] = agm.getNodeArity(i);
            ++i;
        }
        this.graph = new UDGraphImpl(agm.getGraph());
        this.nodePotentials = new NodePotential[this.numOfNodes];
        i = 0;
        while (i < this.numOfNodes) {
            this.nodePotentials[i] = new NodePotential(agm.getNodePotentialTable(i));
            ++i;
        }
        this.cliquePotentials = new Hashtable();
        for (Map.Entry<Integer, Potential> e : agm.getPotentialMap().entrySet()) {
            this.cliquePotentials.put(e.getKey(), new CliquePotential(e.getValue()));
        }
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public int getMaxArity() {
        return this.maxNodeArity;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    public static GraphicalModel load(String file_url) {
        System.out.println("Not yet implemented for general graphs.");
        return null;
    }

    @Override
    public void save(String file_url, int format) {
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public int getNodeArity(int num) {
        return this.nodeArities[num];
    }

    @Override
    public void setNodeArity(int node, int arity) {
        this.nodeArities[node] = arity;
    }

    @Override
    public UDGraph getGraph() {
        return this.graph;
    }

    @Override
    public int getMaxCliqueSize() {
        return this.maxCliqueSize;
    }

    @Override
    public void setMaxCliqueSize(int maxCliqueSize) {
        this.maxCliqueSize = maxCliqueSize;
    }

    @Override
    public void setMaxArity(int max) {
        this.maxNodeArity = max;
    }

    @Override
    public void setNodePotential(int node, int nodelabel, double potVal) {
        if (this.nodePotentials[node] == null) {
            this.nodePotentials[node] = new NodePotential(this.nodeArities[node]);
        }
        int[] toPass = new int[]{nodelabel};
        this.nodePotentials[node].setPotential(toPass, potVal);
    }

    @Override
    public void setCliquePotential(int[] nodes, int[] labels, double pot) {
        int[][] cliques = new int[nodes.length][2];
        int i = 0;
        while (i < nodes.length) {
            cliques[i][0] = nodes[i];
            cliques[i][1] = labels[i];
            ++i;
        }
        Arrays.sort(cliques, new D2ArrayComparator(1));
        i = 0;
        while (i < nodes.length) {
            nodes[i] = cliques[i][0];
            labels[i] = cliques[i][1];
            ++i;
        }
        int key = this.getCliqueKey(nodes);
        Potential cliquePotential = this.cliquePotentials.get(key);
        if (cliquePotential == null) {
            cliquePotential = new CliquePotential(this.maxNodeArity, nodes.length);
        }
        cliquePotential.setPotential(labels, pot);
        this.cliquePotentials.put(key, cliquePotential);
    }

    @Override
    public int getNumNodes() {
        return this.graph == null ? 0 : this.graph.getNumNodes();
    }

    @Override
    boolean isUniformArity() {
        return this.uniformArity;
    }

    @Override
    public Potential getNodePotentialTable(int node) {
        return this.nodePotentials[node];
    }

    public void copyNodePotentialTable(int node, GraphicalModel src, int srcNode) {
        int i = 0;
        while (i < this.nodeArities[node]) {
            this.setNodePotential(node, i, src.getNodePotential(srcNode, i));
            ++i;
        }
    }

    @Override
    public Potential getCliquePotentialTable(int[] nodes) {
        int[][] cliques = new int[nodes.length][2];
        int i = 0;
        while (i < nodes.length) {
            cliques[i][0] = nodes[i];
            ++i;
        }
        Arrays.sort(cliques, new D2ArrayComparator(1));
        i = 0;
        while (i < nodes.length) {
            nodes[i] = cliques[i][0];
            ++i;
        }
        Integer key = this.getCliqueKey(nodes);
        if (this.cliquePotentials.containsKey(key)) {
            return this.cliquePotentials.get(key);
        }
        return this.defaultCliquePotential;
    }

    @Override
    public int[] getNodeArities() {
        return this.nodeArities;
    }

    @Override
    protected int getBitsPerNode() {
        return this.bitsPerNode;
    }

    @Override
    protected Potential getDefaultCliquePotential() {
        return this.defaultCliquePotential;
    }

    @Override
    protected Hashtable<Integer, Potential> getPotentialMap() {
        return this.cliquePotentials;
    }

    @Override
    public double getScore(int[] labeling) {
        return 0.0;
    }

    @Override
    public int getSumArity() {
        int sumArity = 0;
        int li = 0;
        while (li < this.numOfNodes) {
            sumArity += this.nodeArities[li++];
        }
        return sumArity;
    }

    @Override
    public void setCliquePotentialTable(int[] nodes, CliquePotential potential) {
        int key = this.getCliqueKey(nodes);
        this.cliquePotentials.put(key, potential);
    }

    public void setConstraints(Constraints cs) {
        this.constraints = cs;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class D2ArrayComparator
    implements Comparator<int[]> {
        private int coln;

        public D2ArrayComparator(int columnNo) {
            this.coln = columnNo - 1;
        }

        @Override
        public int compare(int[] arg0, int[] arg1) {
            if (arg0[this.coln] < arg1[this.coln]) {
                return -1;
            }
            if (arg0[this.coln] > arg1[this.coln]) {
                return 1;
            }
            return 0;
        }
    }
}

