/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import iitb.ugm.CliquePotential;
import iitb.ugm.Constraint;
import iitb.ugm.PairwisePotential;

public class PairwiseConstraint
implements Constraint {
    int srcNode;
    int dstNode;
    PairwisePotential constraintPotential;
    int[] params = new int[2];

    public PairwiseConstraint(int node1, int node2, PairwisePotential potential) {
        if (node1 > node2) {
            this.srcNode = node2;
            this.dstNode = node1;
        } else {
            this.srcNode = node1;
            this.dstNode = node2;
        }
        this.constraintPotential = potential;
    }

    public boolean isValid(int[] nodes, int[] labels) {
        return this.isValid(nodes[0], labels[0], nodes[1], labels[1]);
    }

    public boolean isValid(int node1, int label1, int node2, int label2) {
        this.params[0] = label1;
        this.params[1] = label2;
        if (node1 > node2) {
            this.params[0] = label2;
            this.params[1] = label1;
        }
        return this.constraintPotential.getPotential(this.params) <= 0.0;
    }

    public int[] getNodes() {
        this.params[0] = this.srcNode;
        this.params[1] = this.dstNode;
        return this.params;
    }

    public CliquePotential getPotential() {
        return this.constraintPotential;
    }
}

