/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import java.util.TreeSet;

public class LogMath {
    public static double LOG0 = -1.7976931348623157E308;
    public static double LOG2 = 0.69314718055;
    static final double MINUS_LOG_EPSILON = 50.0;

    public static double logSumExp(double v1, double v2) {
        if (v1 == v2) {
            return v1 + LOG2;
        }
        double vmin = Math.min(v1, v2);
        double vmax = Math.max(v1, v2);
        if (vmax > vmin + 50.0) {
            return vmax;
        }
        return vmax + Math.log(Math.exp(vmin - vmax) + 1.0);
    }

    public static double logMinusExp(double v1, double v2) throws Exception {
        if (v1 == v2) {
            return LOG0;
        }
        if (v1 < v2) {
            throw new Exception("Cannot take log of negative numbers");
        }
        double vmax = v1;
        double vmin = v2;
        if (vmax > vmin + 50.0) {
            return vmax;
        }
        return vmax + Math.log(1.0 - Math.exp(vmin - vmax));
    }

    static void addNoDups(TreeSet vec, Double val) {
        if (!vec.add(val)) {
            vec.remove(val);
            LogMath.addNoDups(vec, new Double(val + LOG2));
        }
    }

    static double logSumExp(TreeSet logProbVector) {
        while (logProbVector.size() > 1) {
            double lp0 = (Double)logProbVector.first();
            logProbVector.remove(logProbVector.first());
            double lp1 = (Double)logProbVector.first();
            logProbVector.remove(logProbVector.first());
            LogMath.addNoDups(logProbVector, new Double(LogMath.logSumExp(lp0, lp1)));
        }
        return (Double)logProbVector.first();
    }

    public static double exp(double d) {
        if (Double.isInfinite(d) || d < 0.0 && Math.abs(d) > 50.0) {
            return 0.0;
        }
        return Math.exp(d);
    }

    public static double log(float val) {
        return (double)Math.abs(val - 1.0f) < Double.MIN_VALUE ? 0.0 : Math.log(val);
    }

    public static void main(String[] args) {
        double v1 = 188.0;
        double v2 = 189.0;
        System.out.println(LogMath.logSumExp(v1, v2));
    }
}

