/*
 * Decompiled with CFR 0.152.
 */
package iitb.ugm;

import gnu.trove.TIntDoubleHashMap;
import iitb.ugm.Potential;

public class CliquePotential
extends Potential {
    double defaultValue = 0.0;
    private TIntDoubleHashMap potentialMap;
    private int bitsPerNode;

    public CliquePotential(int maxNodeArity, int cliqueSize) {
        int bitsRequired = (int)Math.ceil(Math.log(maxNodeArity + 1) / Math.log(2.0)) * cliqueSize;
        assert (bitsRequired <= 32);
        this.bitsPerNode = bitsRequired / cliqueSize;
        this.variableArity = maxNodeArity;
        this.cliqueSize = cliqueSize;
        this.potentialMap = new TIntDoubleHashMap();
    }

    public CliquePotential(int nodeArity, int cliqueSize, double defaultValue) {
        this(nodeArity, cliqueSize);
        this.defaultValue = defaultValue;
    }

    public CliquePotential(Potential p) {
        this(p.getNodeArity(), p.getCliqueSize());
        TIntDoubleHashMap pPotential = p.getPotentialMap();
        int[] keys = pPotential.keys();
        int i = 0;
        while (i < keys.length) {
            this.potentialMap.put(keys[i], pPotential.get(keys[i]));
            ++i;
        }
    }

    public double getPotential(int[] nodeValues) {
        assert (nodeValues.length <= this.cliqueSize);
        int key = this.getKey(nodeValues);
        if (this.potentialMap.containsKey(key)) {
            return this.potentialMap.get(key);
        }
        return this.defaultValue;
    }

    protected int getKey(int[] labels) {
        assert (labels.length <= this.cliqueSize);
        int key = 0;
        int i = 0;
        while (i < labels.length) {
            key += labels[i];
            key <<= this.bitsPerNode;
            ++i;
        }
        return key;
    }

    public void setPotential(int[] labels, double potentialValue) {
        assert (labels.length <= this.cliqueSize);
        int key = this.getKey(labels);
        this.potentialMap.put(key, potentialValue);
    }

    public double getPartitionValue() {
        return 0.0;
    }

    public int getCliqueSize() {
        return this.cliqueSize;
    }

    protected int getNodeArity() {
        return this.variableArity;
    }

    protected TIntDoubleHashMap getPotentialMap() {
        return this.potentialMap;
    }
}

