/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.newstemmer;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

public class StemmerRuleResult
implements Comparable,
Serializable {
    private static final long serialVersionUID = -158865165318986691L;
    String root = "";
    String paradigm = "";
    String category = "";
    String ultimateDeletion = "";
    LinkedList<String> suffixList = null;

    public String getUltimateDeletion() {
        return this.ultimateDeletion;
    }

    public void setUltimateDeletion(String ultimateDeletion) {
        this.ultimateDeletion = ultimateDeletion;
    }

    public String getParadigm() {
        return this.paradigm;
    }

    public void setParadigm(String paradigm) {
        this.paradigm = paradigm;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public LinkedList<String> getSuffixList() {
        return this.suffixList;
    }

    public void setSuffixList(LinkedList<String> suffixList) {
        this.suffixList = suffixList;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void addSuffix(String suffix) {
        this.suffixList.addFirst(suffix);
    }

    public StemmerRuleResult(String root, String paradigm, String ultimateDeletion, LinkedList<String> suffixList) {
        this.root = root;
        this.paradigm = paradigm;
        this.ultimateDeletion = ultimateDeletion;
        this.suffixList = suffixList;
    }

    public StemmerRuleResult(StemmerRuleResult srr) {
        this.root = srr.getRoot();
        this.paradigm = srr.getParadigm();
        this.ultimateDeletion = srr.getUltimateDeletion();
        this.suffixList = new LinkedList();
        if (srr.suffixList != null) {
            Iterator suffixListIter = this.suffixList.iterator();
            while (suffixListIter.hasNext()) {
                this.suffixList.add((String)suffixListIter.next());
            }
        }
    }

    public StemmerRuleResult(String root, String paradigm, String category, String ultimateDeletion, String suffix) {
        this.root = root;
        this.paradigm = paradigm;
        this.category = category;
        this.ultimateDeletion = ultimateDeletion;
        this.suffixList = new LinkedList();
        this.suffixList.add(suffix);
    }

    public StemmerRuleResult(String root, String paradigm, String category, String ultimateDeletion, LinkedList<String> suffixList) {
        this.root = root;
        this.paradigm = paradigm;
        this.category = category;
        this.ultimateDeletion = ultimateDeletion;
        this.suffixList = suffixList;
    }

    public String toString() {
        String retVal = null;
        retVal = "Root : " + this.root + " Paradigm : " + this.paradigm + " Category : " + this.category + " ultimateDeletion : " + this.ultimateDeletion + " Suffixes : ";
        if (this.suffixList != null) {
            Iterator suffixListIter = this.suffixList.iterator();
            while (suffixListIter.hasNext()) {
                retVal = String.valueOf(retVal) + (String)suffixListIter.next() + "#";
            }
        }
        retVal = retVal.substring(0, retVal.length() - 1);
        return retVal;
    }

    public int getSuffixSize() {
        if (this.suffixList == null) {
            return 0;
        }
        int retVal = this.suffixList.size();
        if (this.suffixList.size() == 1 && this.suffixList.element() == "") {
            --retVal;
        }
        if (this.ultimateDeletion != "") {
            ++retVal;
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StemmerRuleResult)) {
            return false;
        }
        StemmerRuleResult that = (StemmerRuleResult)o;
        return this.paradigm.equals(that.paradigm) && this.root.equals(that.root) && this.ultimateDeletion.equals(that.ultimateDeletion) && (this.category == null && that.category == null || this.category != null && this.category.equals(that.category)) && this.suffixList.equals(that.suffixList);
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public static void main(String[] args) {
        LinkedList<String> test = new LinkedList<String>();
        test.addFirst("Dinesh");
        test.addFirst("Bhaskarrao");
        test.addFirst("Gadge");
        Iterator iter = test.iterator();
        while (iter.hasNext()) {
            System.out.println((String)iter.next());
        }
    }
}

