/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.newstemmer;

import iitb.cfilt.cpost.lexicon.Wordlist;
import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;

public class StemmerRule {
    String category;
    String paradigm;
    String ultimateInsertion;
    String ultimateDeletion;
    String penultimateInsertion;
    String penultimateDeletion;
    int nopud = 0;
    int noud = 0;
    String suffix;
    int priority;
    int depth = 0;
    String suffixToReplace = "";
    public static final String DELIMITER = ",";
    public static final boolean MULTIPLE_POSSIBLE = false;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StemmerRule)) {
            return false;
        }
        StemmerRule that = (StemmerRule)o;
        return this.paradigm.equals(that.paradigm) && this.ultimateInsertion.equals(that.ultimateInsertion) && this.ultimateDeletion.equals(that.ultimateDeletion) && this.penultimateInsertion.equals(that.penultimateInsertion) && this.penultimateDeletion.equals(that.penultimateDeletion) && this.category.equals(that.category) && this.priority == that.priority;
    }

    public String getParadigm() {
        return this.paradigm;
    }

    public void setParadigm(String paradigm) {
        this.paradigm = paradigm;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getPenultimateDeletion() {
        return this.penultimateDeletion;
    }

    public void setPenultimateDeletion(String penultimateDeletion) {
        this.penultimateDeletion = penultimateDeletion;
    }

    public String getPenultimateInsertion() {
        return this.penultimateInsertion;
    }

    public void setPenultimateInsertion(String penultimateInsertion) {
        this.penultimateInsertion = penultimateInsertion;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getUltimateDeletion() {
        return this.ultimateDeletion;
    }

    public void setUltimateDeletion(String ultimateDeletion) {
        this.ultimateDeletion = ultimateDeletion;
    }

    public String getUltimateInsertion() {
        return this.ultimateInsertion;
    }

    public void setUltimateInsertion(String ultimateInsertion) {
        this.ultimateInsertion = ultimateInsertion;
    }

    public String getSuffixToReplace() {
        return this.suffixToReplace;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public StemmerRule(String paradigm, String category, String ultimateInsertion, String ultimateDeletion, String penultimateInsertion, String penultimateDeletion, String suffix, int priority) {
        this.paradigm = paradigm;
        this.category = category;
        this.ultimateInsertion = ultimateInsertion;
        this.ultimateDeletion = ultimateDeletion;
        this.penultimateInsertion = penultimateInsertion;
        this.penultimateDeletion = penultimateDeletion;
        this.suffix = suffix;
        this.priority = priority;
        this.suffixToReplace = "";
    }

    public StemmerRule(String paradigm, String category, String ultimateInsertion, String ultimateDeletion, String penultimateInsertion, String penultimateDeletion, String suffixToReplace, int priority, String suffix) {
        this.paradigm = paradigm;
        this.category = category;
        this.ultimateInsertion = ultimateInsertion;
        this.ultimateDeletion = ultimateDeletion;
        this.penultimateInsertion = penultimateInsertion;
        this.penultimateDeletion = penultimateDeletion;
        this.suffix = suffix;
        this.priority = priority;
        this.suffixToReplace = suffixToReplace;
    }

    public StemmerRule() {
    }

    public StemmerRuleResult applyOn(String token, String suffix) {
        String result;
        StemmerRuleResult retVal;
        block12: {
            boolean b = false;
            retVal = null;
            if (this.ultimateDeletion.length() > 0 && !token.endsWith(this.ultimateDeletion)) {
                return retVal;
            }
            if (this.suffix != null && !suffix.startsWith(this.suffix) && !suffix.equals(this.suffix)) {
                return retVal;
            }
            result = token;
            if (b) {
                System.out.print("1. " + result);
            }
            this.noud = 0;
            this.nopud = 0;
            try {
                result = this.performUltimateDeletionOn(result);
                if (b) {
                    System.out.print(" 2. " + result);
                }
                if (this.noud == 0) {
                    result = this.performPenultimateDeletionOn(result);
                    if (b) {
                        System.out.print(" 3. " + result);
                    }
                    if (this.nopud == 0) {
                        result = this.performPenultimateInsertionOn(result);
                        if (b) {
                            System.out.print(" 4. " + result);
                        }
                        result = this.performUltimateInsertionOn(result);
                        if (b) {
                            System.out.println(" 5. " + result);
                        }
                        break block12;
                    }
                    return null;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        retVal = new StemmerRuleResult(result, this.paradigm, Wordlist.getCategory(this.paradigm), this.ultimateDeletion, suffix);
        return retVal;
    }

    public String applyRule(String token) {
        String retVal;
        String result;
        block13: {
            String suffix = "";
            boolean b = false;
            result = token;
            retVal = "";
            if (this.suffixToReplace == null) {
                return retVal;
            }
            if (this.suffixToReplace.length() == 0) {
                return retVal;
            }
            if (this.suffixToReplace.length() > 0 && !token.endsWith(this.suffixToReplace)) {
                return retVal;
            }
            result = token.replaceAll(String.valueOf(this.suffixToReplace) + "$", "");
            if (b) {
                System.out.print("1. " + result);
            }
            this.noud = 0;
            this.nopud = 0;
            try {
                result = this.performUltimateDeletionOn(result);
                if (b) {
                    System.out.print(" 2. " + result);
                }
                if (this.noud == 0) {
                    result = this.performPenultimateDeletionOn(result);
                    if (b) {
                        System.out.print(" 3. " + result);
                    }
                    if (this.nopud == 0) {
                        result = this.performPenultimateInsertionOn(result);
                        if (b) {
                            System.out.print(" 4. " + result);
                        }
                        result = this.performUltimateInsertionOn(result);
                        if (b) {
                            System.out.println(" 5. " + result);
                        }
                        break block13;
                    }
                    return null;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        retVal = result;
        return retVal;
    }

    private String performUltimateInsertionOn(String result) {
        String retVal = result;
        if (this.ultimateInsertion != null && !this.ultimateInsertion.equals("")) {
            retVal = String.valueOf(retVal) + this.ultimateInsertion;
        }
        return retVal;
    }

    private String performPenultimateInsertionOn(String result) {
        String retVal = result;
        if (this.penultimateInsertion != null && !this.penultimateInsertion.equals("")) {
            retVal = result.length() > 0 ? String.valueOf(retVal.substring(0, retVal.length() - 1)) + this.penultimateInsertion + retVal.substring(retVal.length() - 1) : this.penultimateInsertion;
        }
        return retVal;
    }

    private String performPenultimateDeletionOn(String result) throws Exception {
        String retVal = result;
        if (this.penultimateDeletion != null && !this.penultimateDeletion.equals("")) {
            int lastIndexOfpud = retVal.lastIndexOf(this.penultimateDeletion);
            if (!retVal.endsWith(this.penultimateDeletion)) {
                if (lastIndexOfpud != -1) {
                    retVal = String.valueOf(retVal.substring(0, lastIndexOfpud)) + retVal.substring(lastIndexOfpud).replaceFirst(this.penultimateDeletion, "");
                } else {
                    this.nopud = 1;
                }
            } else {
                String tempRetVal = retVal.replaceAll(String.valueOf(this.penultimateDeletion) + "$", "");
                retVal = String.valueOf(this.performPenultimateDeletionOn(tempRetVal)) + this.penultimateDeletion;
            }
        }
        return retVal;
    }

    public String string() {
        String ret = "";
        ret = String.valueOf(this.category) + ", " + this.paradigm + ", " + this.ultimateInsertion + ", " + this.ultimateDeletion + ", " + this.penultimateInsertion + ", " + this.penultimateDeletion + ", " + this.suffix;
        return ret;
    }

    private String performUltimateDeletionOn(String result) throws Exception {
        String retVal = result;
        if (this.ultimateDeletion != null && !this.ultimateDeletion.equals("")) {
            if (this.paradigm.equals("nst")) {
                System.out.println("nst");
            }
            if (retVal.endsWith(this.ultimateDeletion)) {
                retVal = retVal.replaceAll(String.valueOf(this.ultimateDeletion) + "$", "");
            } else {
                this.noud = 1;
            }
        }
        return retVal;
    }

    public static void main(String[] args) {
        String test = "Dinesh,Gadge,,,hey,hello,,,1";
        String[] tests = test.split(DELIMITER);
        int i = 0;
        while (i < tests.length) {
            System.out.println("'" + tests[i] + "'" + " " + tests[i].equals(""));
            ++i;
        }
        String t = "Dinesh";
        System.out.println(t);
        System.out.println(t.replaceAll("esh$", ""));
        System.out.println(t);
        String retVal = "Dineshesh";
        System.out.println(retVal.substring(0, retVal.length() - 1));
    }
}

