/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.newstemmer;

import iitb.cfilt.cpost.newstemmer.StemmerRuleResult;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;

public class StemmedToken
implements Serializable {
    private static final long serialVersionUID = 8424882257677766336L;
    private String token;
    private Vector<StemmerRuleResult> stemmedOutputs;

    public StemmedToken(String token) {
        this.token = token;
        this.stemmedOutputs = new Vector();
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void sortResults() {
        Collections.sort(this.stemmedOutputs);
    }

    public String getToken() {
        return this.token;
    }

    public boolean addStemmerOutput(StemmerRuleResult srresult) {
        return this.stemmedOutputs.add(srresult);
    }

    public boolean addAllStemmerOutputs(Vector<StemmerRuleResult> srresult) {
        return this.stemmedOutputs.addAll(srresult);
    }

    public Vector<StemmerRuleResult> getStemmedOutputs() {
        return this.stemmedOutputs;
    }

    public void resetStemmedOutputs() {
        this.stemmedOutputs = new Vector();
    }

    public void clearOutputs() {
        this.stemmedOutputs.clear();
    }

    public String getAmbiguityScheme() {
        String retVal = "";
        HashSet<String> categorySet = new HashSet<String>();
        for (StemmerRuleResult stemmedOutput : this.stemmedOutputs) {
            String cat = stemmedOutput.getCategory().trim();
            if (cat.equals("unknown")) continue;
            categorySet.add(cat);
        }
        Vector categoryList = new Vector(categorySet);
        Collections.sort(categoryList);
        int i = 0;
        while (i < categoryList.size()) {
            retVal = String.valueOf(retVal) + (String)categoryList.get(i) + "*";
            ++i;
        }
        if (!retVal.equals("")) {
            retVal = retVal.substring(0, retVal.length() - 1);
        }
        return retVal;
    }
}

