/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost;

import iitb.cfilt.cpost.UTFWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

class SSFToNormal {
    UTFWriter obw;
    Vector<String> tokens = new Vector();
    Vector<String> tags = new Vector();
    Vector<String> corrections = new Vector();
    int cnt = 0;

    SSFToNormal(String filename, String strOut) {
        try {
            File outFile = new File(strOut);
            if (outFile.exists()) {
                outFile.delete();
                outFile = new File(strOut);
            }
            this.convert(filename);
            this.cleaning();
            System.out.println("Tokens : " + this.tokens.size() + " Tags : " + this.tags.size() + "Corrections : " + this.corrections.size());
            this.obw = new UTFWriter(outFile);
            this.convertagain(filename);
            this.obw.close();
            System.out.println("Tokens : " + this.tokens.size() + " Tags : " + this.tags.size() + "Corrections : " + this.corrections.size());
            System.out.println("Done!");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    void convert(String filename) {
        try {
            File file = new File(filename);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.convert(files[i].getAbsolutePath());
                    ++i;
                }
            } else {
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
                String line = "";
                boolean in_sentence = false;
                while ((line = bf.readLine()) != null) {
                    String[] temp;
                    if (!(line = line.trim()).startsWith("<Sentence id") && !in_sentence) continue;
                    if (line.startsWith("<Sentence id")) {
                        in_sentence = true;
                        continue;
                    }
                    if (line.startsWith("</Sentence>")) {
                        in_sentence = false;
                        continue;
                    }
                    if (!in_sentence || line.startsWith("0\t") || (temp = line.split("\t")).length < 3) continue;
                    this.tokens.add(temp[1].trim());
                    this.tags.add(temp[2].trim());
                }
                bf.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    void cleaning() {
        try {
            BufferedReader bf1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/mnt/dgf1/home/sachinp/TrainingData/aataa"), "UTF8"));
            String line = "";
            while ((line = bf1.readLine()) != null) {
                if (line.startsWith("//")) continue;
                this.corrections.add(line.trim());
            }
            String curr_tag = "";
            int i = this.tags.size() - 1;
            while (i >= 0) {
                if (!this.tags.get(i).equals("XC")) {
                    curr_tag = this.tags.get(i);
                } else {
                    this.tags.set(i, curr_tag.concat("C"));
                }
                if (this.tags.get(i).endsWith("?")) {
                    String tt = this.tags.get(i);
                    int len = tt.length();
                    this.tags.set(i, tt.substring(0, len - 2));
                }
                int z = 0;
                while (z < this.corrections.size()) {
                    if (this.tokens.get(i).startsWith(this.corrections.get(z))) {
                        this.tags.set(i, "NN");
                    }
                    ++z;
                }
                --i;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    void convertagain(String filename) {
        try {
            File file = new File(filename);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.convertagain(files[i].getAbsolutePath());
                    ++i;
                }
            } else {
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
                String line = "";
                boolean in_sentence = false;
                String newSentence = "";
                while ((line = bf.readLine()) != null) {
                    String[] temp;
                    if (!(line = line.trim()).startsWith("<Sentence id") && !in_sentence) continue;
                    if (line.startsWith("<Sentence id")) {
                        in_sentence = true;
                        newSentence = "";
                        continue;
                    }
                    if (line.startsWith("</Sentence>")) {
                        in_sentence = false;
                        this.obw.writeUTF(String.valueOf(newSentence) + "\n");
                        continue;
                    }
                    if (!in_sentence || line.startsWith("0\t") || (temp = line.split("\t")).length < 3) continue;
                    newSentence = String.valueOf(newSentence) + temp[1].trim() + "_[ " + this.tags.get(this.cnt) + " ] ";
                    ++this.cnt;
                }
                bf.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SSFToNormal ob = new SSFToNormal(args[0], args[1]);
    }
}

