/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost.MrLexicon;

import iitb.cfilt.cpost.ConfigReader;
import iitb.cfilt.cpost.MrLexicon.WordProperties;
import iitb.cfilt.cpost.UTFConsole;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Wordlist {
    private static HashMap<String, HashMap<String, Vector<String>>> wordHash;
    private static HashMap<String, Vector<WordProperties>> wordToPropertiesMap;
    private static HashMap<String, String> parCat;
    private static HashMap<String, HashMap<String, HashSet<String>>> wordParadigmHash;
    private static String lexName;
    private static boolean populated;
    public static HashMap<String, HashMap<String, HashSet<String>>> firstcharCatParHash;
    public static Vector<String> temp;

    static {
        lexName = "";
        populated = false;
        temp = new Vector();
    }

    private Wordlist() {
    }

    public static void populate() {
        if (!lexName.equals(ConfigReader.get("Lexicon.lexName"))) {
            populated = false;
        }
        if (!populated) {
            lexName = ConfigReader.get("Lexicon.lexName");
            wordHash = new HashMap();
            wordToPropertiesMap = new HashMap();
            parCat = new HashMap();
            wordParadigmHash = new HashMap();
            firstcharCatParHash = new HashMap();
            Wordlist.generateWordlist(lexName);
            populated = true;
        }
    }

    public static void populate(String baseDir) {
        if (!lexName.equals(String.valueOf(baseDir) + ConfigReader.get("Lexicon.lexName"))) {
            populated = false;
        }
        if (!populated) {
            lexName = String.valueOf(baseDir) + ConfigReader.get("Lexicon.lexName");
            wordHash = new HashMap();
            wordToPropertiesMap = new HashMap();
            parCat = new HashMap();
            wordParadigmHash = new HashMap();
            firstcharCatParHash = new HashMap();
            Wordlist.generateWordlist(lexName);
            populated = true;
        }
    }

    public static void populateFromFile(String strLexFile) {
        wordHash = new HashMap();
        wordToPropertiesMap = new HashMap();
        parCat = new HashMap();
        Wordlist.generateWordlist(strLexFile);
        populated = true;
    }

    private static void generateWordlist(String lexiconFilename) {
        try {
            BufferedReader bRead = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(lexiconFilename), "UTF8"));
            String line = " ";
            while (line != null) {
                line = bRead.readLine();
                if (line == null || (line = line.trim()).length() == 0 || line.startsWith("//")) continue;
                Wordlist.hashIt(line);
            }
            bRead.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getCategory(String paradigm) {
        return parCat.get(paradigm);
    }

    public static void hashLine(String line) {
        Wordlist.hashIt(line);
    }

    private static void hashIt(String line) {
        Vector<Object> props;
        HashSet parSet;
        HashMap<Object, Object> wordPar;
        HashSet parSet2;
        HashMap<Object, Object> catParHash;
        Pattern pEnd = Pattern.compile(">");
        Matcher mEnd = pEnd.matcher(line);
        line = mEnd.replaceAll("");
        Pattern pStart = Pattern.compile("<");
        Matcher mStart = pStart.matcher(line);
        line = mStart.replaceAll("");
        Pattern pSplit = Pattern.compile(",");
        String[] lineComponents = pSplit.split(line);
        String word = lineComponents[0].trim();
        String paradigm = lineComponents[1].trim();
        String category = lineComponents[2].trim();
        String firstchar = word.substring(0, 1);
        if (firstcharCatParHash.containsKey(firstchar)) {
            catParHash = firstcharCatParHash.get(firstchar);
            if (catParHash.containsKey(category)) {
                parSet2 = (HashSet)catParHash.get(category);
                if (!parSet2.contains(paradigm)) {
                    parSet2.add(paradigm);
                    catParHash.put(category, parSet2);
                }
            } else {
                parSet2 = new HashSet();
                parSet2.add(paradigm);
                catParHash.put(category, parSet2);
            }
        } else {
            catParHash = new HashMap();
            parSet2 = new HashSet();
            parSet2.add(paradigm);
            catParHash.put(category, parSet2);
            firstcharCatParHash.put(firstchar, catParHash);
        }
        temp.add(word);
        String hashChar = null;
        hashChar = word.length() >= 2 ? word.substring(0, 2) : word.substring(0, 1);
        if (wordParadigmHash.containsKey(hashChar)) {
            wordPar = wordParadigmHash.get(hashChar);
            if (wordPar.containsKey(word)) {
                parSet = (HashSet)wordPar.get(word);
                parSet.add(paradigm);
                wordPar.put(word, parSet);
            } else {
                parSet = new HashSet();
                parSet.add(paradigm);
                wordPar.put(word, parSet);
            }
        } else {
            wordPar = new HashMap();
            parSet = new HashSet();
            parSet.add(paradigm);
            wordPar.put(word, parSet);
            wordParadigmHash.put(hashChar, wordPar);
        }
        parCat.put(paradigm, category);
        String first_char = word.substring(0, 1);
        if (wordHash.containsKey(first_char)) {
            Vector<Object> words;
            HashMap<String, Vector<String>> par_word = wordHash.get(first_char);
            if (par_word.containsKey(paradigm)) {
                words = par_word.get(paradigm);
                words.add(word.trim());
                par_word.put(paradigm, words);
                wordHash.put(first_char, par_word);
            } else {
                words = new Vector();
                words.add(word.trim());
                par_word.put(paradigm, words);
                wordHash.put(first_char, par_word);
            }
        } else {
            Vector<String> words = new Vector<String>();
            HashMap<String, Vector<String>> par_word = new HashMap<String, Vector<String>>();
            words.add(word.trim());
            par_word.put(paradigm, words);
            wordHash.put(first_char, par_word);
        }
        if (wordToPropertiesMap.containsKey(word)) {
            WordProperties newProperties;
            props = wordToPropertiesMap.get(word);
            if (!props.contains(newProperties = new WordProperties(paradigm, category))) {
                props.add(newProperties);
            }
        } else {
            props = new Vector();
            props.add(new WordProperties(paradigm, category));
            wordToPropertiesMap.put(word, props);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WordProperties lookup(String s, String par) {
        WordProperties retVal = null;
        String hashChar = null;
        if (s.length() >= 2) {
            hashChar = s.substring(0, 2);
        } else {
            if (s.length() != 1) return null;
            hashChar = s.substring(0, 1);
        }
        if (!wordParadigmHash.containsKey(hashChar)) return null;
        HashMap<String, HashSet<String>> wordPar = wordParadigmHash.get(hashChar);
        if (!wordPar.containsKey(s)) return null;
        if (!wordPar.get(s).contains(par)) return null;
        return new WordProperties(par, parCat.get(par));
    }

    public static WordProperties searchWordlistFor(String s, String par) {
        HashMap<String, Vector<String>> par_word;
        Vector<String> words;
        String first_char;
        WordProperties retVal = null;
        s = s.trim();
        par = par.trim();
        if (!s.equals(null) && !s.equals("") && wordHash.containsKey(first_char = s.substring(0, 1)) && (words = (par_word = wordHash.get(first_char)).get(par)) != null && words.contains(s)) {
            retVal = new WordProperties(par, parCat.get(par));
        }
        return retVal;
    }

    public static Vector<WordProperties> searchWordlistFor(String s) {
        String firstChar;
        Vector<WordProperties> retVal = null;
        if (!(s = s.trim()).equals(null) && !s.equals("") && wordHash.containsKey(firstChar = s.substring(0, 1))) {
            retVal = new Vector<WordProperties>();
            HashMap<String, Vector<String>> par_word = wordHash.get(firstChar);
            Set<String> paradigms = par_word.keySet();
            for (String par : paradigms) {
                if (!par_word.get(par).contains(s)) continue;
                WordProperties wp = new WordProperties(par, parCat.get(par));
                retVal.add(wp);
            }
        }
        return retVal;
    }

    public static Set<String> getAmbiguitySchemes() {
        HashSet<String> retVal = new HashSet<String>();
        Set<String> words = wordToPropertiesMap.keySet();
        HashSet<String> currentCategories = new HashSet<String>();
        for (String word : words) {
            Vector<WordProperties> props = wordToPropertiesMap.get(word);
            for (WordProperties property : props) {
                currentCategories.add(property.getCategory());
            }
            Vector currentCategoriesVector = new Vector(currentCategories);
            Collections.sort(currentCategoriesVector);
            String currentCategoryString = "";
            for (String category : currentCategoriesVector) {
                currentCategoryString = String.valueOf(currentCategoryString) + category + "*";
            }
            retVal.add(currentCategoryString.substring(0, currentCategoryString.length() - 1));
        }
        return retVal;
    }

    public static void main(String[] args) {
        ConfigReader.read(args[0]);
        Wordlist.populate();
        for (String firstchar : firstcharCatParHash.keySet()) {
            UTFConsole.out.println(firstchar);
            HashMap<String, HashSet<String>> catParHash = firstcharCatParHash.get(firstchar);
            for (String category : catParHash.keySet()) {
                HashSet<String> parSet = catParHash.get(category);
                UTFConsole.out.println(String.valueOf(category) + ":" + parSet);
            }
        }
        UTFConsole.out.println(firstcharCatParHash);
    }
}

