/*
 * Decompiled with CFR 0.152.
 */
package iitb.cfilt.cpost;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfigReader {
    static HashMap<String, String> config;

    public static String get(String key) {
        return config.get(key);
    }

    public static void printValues() {
        Set<Map.Entry<String, String>> s = config.entrySet();
        for (Map.Entry<String, String> me : s) {
            System.out.println(me.getKey() + " " + me.getValue());
        }
    }

    public static void read(String configFile) {
        try {
            BufferedReader bcfr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF8"));
            String varPrefix = "";
            String dir = System.getenv("POS_HOME");
            if (dir.endsWith("//")) {
                int l = dir.length();
                dir = dir.substring(0, l - 2);
            }
            String line = null;
            config = new HashMap();
            while ((line = bcfr.readLine()) != null) {
                if (line.equals("")) continue;
                if (line.startsWith("[") && line.trim().endsWith("]")) {
                    varPrefix = String.valueOf(line.substring(1, line.indexOf("]"))) + ".";
                    continue;
                }
                int indexOfEqual = line.indexOf("=");
                String varName = line.substring(0, indexOfEqual).trim();
                String value = line.substring(indexOfEqual + 1).trim();
                if (dir != "" && !value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("true")) {
                    value = String.valueOf(dir) + "//" + "pos_resources" + "//" + value;
                }
                config.put(String.valueOf(varPrefix) + varName, value);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ConfigReader.read(args[0]);
        ConfigReader.printValues();
    }
}

