/*
 * Decompiled with CFR 0.152.
 */
package iitb.Utils;

import iitb.Utils.ObjectHeap;
import java.util.ArrayList;

public abstract class StaticObjectHeap
extends ObjectHeap {
    protected ArrayList objects = new ArrayList();
    protected int curIndex = 0;

    public StaticObjectHeap(int initCapacity) {
        super(initCapacity);
        this.reset();
        int i = 0;
        while (i < initCapacity) {
            this.addObject();
            ++i;
        }
    }

    public Object getFreeObject() {
        if (this.curIndex >= this.objects.size()) {
            this.addObject();
            this.curIndex = this.objects.size() - 1;
        }
        return this.objects.get(this.curIndex++);
    }

    protected boolean addObject() {
        return this.objects.add(this.newObject());
    }

    protected abstract Object newObject();

    protected abstract Object getObject();

    public void reset() {
        this.curIndex = 0;
    }

    public void clear() {
        this.objects.clear();
        this.reset();
    }

    public void setObjectHeap(int capacity) {
        block3: {
            block2: {
                if (this.objects.size() >= capacity) break block2;
                int i = capacity - this.objects.size();
                while (i >= 0) {
                    this.addObject();
                    --i;
                }
                break block3;
            }
            if (this.objects.size() <= capacity) break block3;
            int i = this.objects.size() - capacity;
            while (i >= 0) {
                this.objects.remove(capacity + i);
                --i;
            }
        }
    }
}

