/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import java.io.Serializable;

public class EigenvalueDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private int n;
    private boolean issymmetric;
    private double[] d;
    private double[] e;
    private double[][] V;
    private double[][] H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;

    public EigenvalueDecomposition(DoubleMatrix2D doubleMatrix2D) {
        Property.DEFAULT.checkSquare(doubleMatrix2D);
        this.n = doubleMatrix2D.columns();
        this.V = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = Property.DEFAULT.isSymmetric(doubleMatrix2D);
        if (this.issymmetric) {
            int n = 0;
            while (n < this.n) {
                int n2 = 0;
                while (n2 < this.n) {
                    this.V[n][n2] = doubleMatrix2D.getQuick(n, n2);
                    ++n2;
                }
                ++n;
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new double[this.n][this.n];
            this.ort = new double[this.n];
            int n = 0;
            while (n < this.n) {
                int n3 = 0;
                while (n3 < this.n) {
                    this.H[n3][n] = doubleMatrix2D.getQuick(n3, n);
                    ++n3;
                }
                ++n;
            }
            this.orthes();
            this.hqr2();
        }
    }

    private void cdiv(double d, double d2, double d3, double d4) {
        if (Math.abs(d3) > Math.abs(d4)) {
            double d5 = d4 / d3;
            double d6 = d3 + d5 * d4;
            this.cdivr = (d + d5 * d2) / d6;
            this.cdivi = (d2 - d5 * d) / d6;
        } else {
            double d7 = d3 / d4;
            double d8 = d4 + d7 * d3;
            this.cdivr = (d7 * d + d2) / d8;
            this.cdivi = (d7 * d2 - d) / d8;
        }
    }

    public DoubleMatrix2D getD() {
        double[][] dArray = new double[this.n][this.n];
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = 0.0;
                ++n2;
            }
            dArray[n][n] = this.d[n];
            if (this.e[n] > 0.0) {
                dArray[n][n + 1] = this.e[n];
            } else if (this.e[n] < 0.0) {
                dArray[n][n - 1] = this.e[n];
            }
            ++n;
        }
        return DoubleFactory2D.dense.make(dArray);
    }

    public DoubleMatrix1D getImagEigenvalues() {
        return DoubleFactory1D.dense.make(this.e);
    }

    public DoubleMatrix1D getRealEigenvalues() {
        return DoubleFactory1D.dense.make(this.d);
    }

    public DoubleMatrix2D getV() {
        return DoubleFactory2D.dense.make(this.V);
    }

    private void hqr2() {
        double d;
        int n;
        int n2;
        double d2;
        double d3;
        int n3;
        int n4;
        int n5 = this.n;
        int n6 = n5 - 1;
        int n7 = 0;
        int n8 = n5 - 1;
        double d4 = Math.pow(2.0, -52.0);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n9 = 0;
        while (n9 < n5) {
            if (n9 < n7 | n9 > n8) {
                this.d[n9] = this.H[n9][n9];
                this.e[n9] = 0.0;
            }
            n4 = Math.max(n9 - 1, 0);
            while (n4 < n5) {
                d11 += Math.abs(this.H[n9][n4]);
                ++n4;
            }
            ++n9;
        }
        n4 = 0;
        block2: while (n6 >= n7) {
            int n10;
            n3 = n6;
            while (n3 > n7) {
                d9 = Math.abs(this.H[n3 - 1][n3 - 1]) + Math.abs(this.H[n3][n3]);
                if (d9 == 0.0) {
                    d9 = d11;
                }
                if (Math.abs(this.H[n3][n3 - 1]) < d4 * d9) break;
                --n3;
            }
            if (n3 == n6) {
                this.H[n6][n6] = this.H[n6][n6] + d5;
                this.d[n6] = this.H[n6][n6];
                this.e[n6] = 0.0;
                --n6;
                n4 = 0;
                continue;
            }
            if (n3 == n6 - 1) {
                d3 = this.H[n6][n6 - 1] * this.H[n6 - 1][n6];
                d6 = (this.H[n6 - 1][n6 - 1] - this.H[n6][n6]) / 2.0;
                d7 = d6 * d6 + d3;
                d10 = Math.sqrt(Math.abs(d7));
                this.H[n6][n6] = this.H[n6][n6] + d5;
                this.H[n6 - 1][n6 - 1] = this.H[n6 - 1][n6 - 1] + d5;
                d2 = this.H[n6][n6];
                if (d7 >= 0.0) {
                    d10 = d6 >= 0.0 ? d6 + d10 : d6 - d10;
                    this.d[n6 - 1] = d2 + d10;
                    this.d[n6] = this.d[n6 - 1];
                    if (d10 != 0.0) {
                        this.d[n6] = d2 - d3 / d10;
                    }
                    this.e[n6 - 1] = 0.0;
                    this.e[n6] = 0.0;
                    d2 = this.H[n6][n6 - 1];
                    d9 = Math.abs(d2) + Math.abs(d10);
                    d6 = d2 / d9;
                    d7 = d10 / d9;
                    d8 = Math.sqrt(d6 * d6 + d7 * d7);
                    d6 /= d8;
                    d7 /= d8;
                    n2 = n6 - 1;
                    while (n2 < n5) {
                        d10 = this.H[n6 - 1][n2];
                        this.H[n6 - 1][n2] = d7 * d10 + d6 * this.H[n6][n2];
                        this.H[n6][n2] = d7 * this.H[n6][n2] - d6 * d10;
                        ++n2;
                    }
                    n10 = 0;
                    while (n10 <= n6) {
                        d10 = this.H[n10][n6 - 1];
                        this.H[n10][n6 - 1] = d7 * d10 + d6 * this.H[n10][n6];
                        this.H[n10][n6] = d7 * this.H[n10][n6] - d6 * d10;
                        ++n10;
                    }
                    n = n7;
                    while (n <= n8) {
                        d10 = this.V[n][n6 - 1];
                        this.V[n][n6 - 1] = d7 * d10 + d6 * this.V[n][n6];
                        this.V[n][n6] = d7 * this.V[n][n6] - d6 * d10;
                        ++n;
                    }
                } else {
                    this.d[n6 - 1] = d2 + d6;
                    this.d[n6] = d2 + d6;
                    this.e[n6 - 1] = d10;
                    this.e[n6] = -d10;
                }
                n6 -= 2;
                n4 = 0;
                continue;
            }
            d2 = this.H[n6][n6];
            d = 0.0;
            d3 = 0.0;
            if (n3 < n6) {
                d = this.H[n6 - 1][n6 - 1];
                d3 = this.H[n6][n6 - 1] * this.H[n6 - 1][n6];
            }
            if (n4 == 10) {
                d5 += d2;
                n2 = n7;
                while (n2 <= n6) {
                    double[] dArray = this.H[n2];
                    int n11 = n2++;
                    dArray[n11] = dArray[n11] - d2;
                }
                d9 = Math.abs(this.H[n6][n6 - 1]) + Math.abs(this.H[n6 - 1][n6 - 2]);
                d2 = d = 0.75 * d9;
                d3 = -0.4375 * d9 * d9;
            }
            if (n4 == 30) {
                d9 = (d - d2) / 2.0;
                if ((d9 = d9 * d9 + d3) > 0.0) {
                    d9 = Math.sqrt(d9);
                    if (d < d2) {
                        d9 = -d9;
                    }
                    d9 = d2 - d3 / ((d - d2) / 2.0 + d9);
                    n2 = n7;
                    while (n2 <= n6) {
                        double[] dArray = this.H[n2];
                        int n12 = n2++;
                        dArray[n12] = dArray[n12] - d9;
                    }
                    d5 += d9;
                    d3 = 0.964;
                    d = 0.964;
                    d2 = 0.964;
                }
            }
            ++n4;
            n2 = n6 - 2;
            while (n2 >= n3) {
                d10 = this.H[n2][n2];
                d8 = d2 - d10;
                d9 = d - d10;
                d6 = (d8 * d9 - d3) / this.H[n2 + 1][n2] + this.H[n2][n2 + 1];
                d7 = this.H[n2 + 1][n2 + 1] - d10 - d8 - d9;
                d8 = this.H[n2 + 2][n2 + 1];
                d9 = Math.abs(d6) + Math.abs(d7) + Math.abs(d8);
                if (n2 == n3 || Math.abs(this.H[n2][n2 - 1]) * (Math.abs(d7 /= d9) + Math.abs(d8 /= d9)) < d4 * (Math.abs(d6 /= d9) * (Math.abs(this.H[n2 - 1][n2 - 1]) + Math.abs(d10) + Math.abs(this.H[n2 + 1][n2 + 1])))) break;
                --n2;
            }
            n10 = n2 + 2;
            while (n10 <= n6) {
                this.H[n10][n10 - 2] = 0.0;
                if (n10 > n2 + 2) {
                    this.H[n10][n10 - 3] = 0.0;
                }
                ++n10;
            }
            n = n2;
            while (n <= n6 - 1) {
                boolean bl;
                boolean bl2 = bl = n != n6 - 1;
                if (n != n2) {
                    d6 = this.H[n][n - 1];
                    d7 = this.H[n + 1][n - 1];
                    d8 = bl ? this.H[n + 2][n - 1] : 0.0;
                    d2 = Math.abs(d6) + Math.abs(d7) + Math.abs(d8);
                    if (d2 != 0.0) {
                        d6 /= d2;
                        d7 /= d2;
                        d8 /= d2;
                    }
                }
                if (d2 == 0.0) continue block2;
                d9 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8);
                if (d6 < 0.0) {
                    d9 = -d9;
                }
                if (d9 != 0.0) {
                    if (n != n2) {
                        this.H[n][n - 1] = -d9 * d2;
                    } else if (n3 != n2) {
                        this.H[n][n - 1] = -this.H[n][n - 1];
                    }
                    d2 = (d6 += d9) / d9;
                    d = d7 / d9;
                    d10 = d8 / d9;
                    d7 /= d6;
                    d8 /= d6;
                    int n13 = n;
                    while (n13 < n5) {
                        d6 = this.H[n][n13] + d7 * this.H[n + 1][n13];
                        if (bl) {
                            this.H[n + 2][n13] = this.H[n + 2][n13] - (d6 += d8 * this.H[n + 2][n13]) * d10;
                        }
                        this.H[n][n13] = this.H[n][n13] - d6 * d2;
                        this.H[n + 1][n13] = this.H[n + 1][n13] - d6 * d;
                        ++n13;
                    }
                    int n14 = 0;
                    while (n14 <= Math.min(n6, n + 3)) {
                        d6 = d2 * this.H[n14][n] + d * this.H[n14][n + 1];
                        if (bl) {
                            this.H[n14][n + 2] = this.H[n14][n + 2] - (d6 += d10 * this.H[n14][n + 2]) * d8;
                        }
                        this.H[n14][n] = this.H[n14][n] - d6;
                        this.H[n14][n + 1] = this.H[n14][n + 1] - d6 * d7;
                        ++n14;
                    }
                    int n15 = n7;
                    while (n15 <= n8) {
                        d6 = d2 * this.V[n15][n] + d * this.V[n15][n + 1];
                        if (bl) {
                            this.V[n15][n + 2] = this.V[n15][n + 2] - (d6 += d10 * this.V[n15][n + 2]) * d8;
                        }
                        this.V[n15][n] = this.V[n15][n] - d6;
                        this.V[n15][n + 1] = this.V[n15][n + 1] - d6 * d7;
                        ++n15;
                    }
                }
                ++n;
            }
        }
        if (d11 == 0.0) {
            return;
        }
        n6 = n5 - 1;
        while (n6 >= 0) {
            double d12;
            d6 = this.d[n6];
            d7 = this.e[n6];
            if (d7 == 0.0) {
                n3 = n6;
                this.H[n6][n6] = 1.0;
                n2 = n6 - 1;
                while (n2 >= 0) {
                    d3 = this.H[n2][n2] - d6;
                    d8 = 0.0;
                    int n16 = n3;
                    while (n16 <= n6) {
                        d8 += this.H[n2][n16] * this.H[n16][n6];
                        ++n16;
                    }
                    if (this.e[n2] < 0.0) {
                        d10 = d3;
                        d9 = d8;
                    } else {
                        n3 = n2;
                        if (this.e[n2] == 0.0) {
                            this.H[n2][n6] = d3 != 0.0 ? -d8 / d3 : -d8 / (d4 * d11);
                        } else {
                            d2 = this.H[n2][n2 + 1];
                            d = this.H[n2 + 1][n2];
                            d7 = (this.d[n2] - d6) * (this.d[n2] - d6) + this.e[n2] * this.e[n2];
                            this.H[n2][n6] = d12 = (d2 * d9 - d10 * d8) / d7;
                            this.H[n2 + 1][n6] = Math.abs(d2) > Math.abs(d10) ? (-d8 - d3 * d12) / d2 : (-d9 - d * d12) / d10;
                        }
                        d12 = Math.abs(this.H[n2][n6]);
                        if (d4 * d12 * d12 > 1.0) {
                            n = n2;
                            while (n <= n6) {
                                this.H[n][n6] = this.H[n][n6] / d12;
                                ++n;
                            }
                        }
                    }
                    --n2;
                }
            } else if (d7 < 0.0) {
                n3 = n6 - 1;
                if (Math.abs(this.H[n6][n6 - 1]) > Math.abs(this.H[n6 - 1][n6])) {
                    this.H[n6 - 1][n6 - 1] = d7 / this.H[n6][n6 - 1];
                    this.H[n6 - 1][n6] = -(this.H[n6][n6] - d6) / this.H[n6][n6 - 1];
                } else {
                    this.cdiv(0.0, -this.H[n6 - 1][n6], this.H[n6 - 1][n6 - 1] - d6, d7);
                    this.H[n6 - 1][n6 - 1] = this.cdivr;
                    this.H[n6 - 1][n6] = this.cdivi;
                }
                this.H[n6][n6 - 1] = 0.0;
                this.H[n6][n6] = 1.0;
                n2 = n6 - 2;
                while (n2 >= 0) {
                    double d13 = 0.0;
                    double d14 = 0.0;
                    int n17 = n3;
                    while (n17 <= n6) {
                        d13 += this.H[n2][n17] * this.H[n17][n6 - 1];
                        d14 += this.H[n2][n17] * this.H[n17][n6];
                        ++n17;
                    }
                    d3 = this.H[n2][n2] - d6;
                    if (this.e[n2] < 0.0) {
                        d10 = d3;
                        d8 = d13;
                        d9 = d14;
                    } else {
                        n3 = n2;
                        if (this.e[n2] == 0.0) {
                            this.cdiv(-d13, -d14, d3, d7);
                            this.H[n2][n6 - 1] = this.cdivr;
                            this.H[n2][n6] = this.cdivi;
                        } else {
                            double d15;
                            d2 = this.H[n2][n2 + 1];
                            d = this.H[n2 + 1][n2];
                            double d16 = (this.d[n2] - d6) * (this.d[n2] - d6) + this.e[n2] * this.e[n2] - d7 * d7;
                            if (d16 == 0.0 & (d15 = (this.d[n2] - d6) * 2.0 * d7) == 0.0) {
                                d16 = d4 * d11 * (Math.abs(d3) + Math.abs(d7) + Math.abs(d2) + Math.abs(d) + Math.abs(d10));
                            }
                            this.cdiv(d2 * d8 - d10 * d13 + d7 * d14, d2 * d9 - d10 * d14 - d7 * d13, d16, d15);
                            this.H[n2][n6 - 1] = this.cdivr;
                            this.H[n2][n6] = this.cdivi;
                            if (Math.abs(d2) > Math.abs(d10) + Math.abs(d7)) {
                                this.H[n2 + 1][n6 - 1] = (-d13 - d3 * this.H[n2][n6 - 1] + d7 * this.H[n2][n6]) / d2;
                                this.H[n2 + 1][n6] = (-d14 - d3 * this.H[n2][n6] - d7 * this.H[n2][n6 - 1]) / d2;
                            } else {
                                this.cdiv(-d8 - d * this.H[n2][n6 - 1], -d9 - d * this.H[n2][n6], d10, d7);
                                this.H[n2 + 1][n6 - 1] = this.cdivr;
                                this.H[n2 + 1][n6] = this.cdivi;
                            }
                        }
                        d12 = Math.max(Math.abs(this.H[n2][n6 - 1]), Math.abs(this.H[n2][n6]));
                        if (d4 * d12 * d12 > 1.0) {
                            int n18 = n2;
                            while (n18 <= n6) {
                                this.H[n18][n6 - 1] = this.H[n18][n6 - 1] / d12;
                                this.H[n18][n6] = this.H[n18][n6] / d12;
                                ++n18;
                            }
                        }
                    }
                    --n2;
                }
            }
            --n6;
        }
        n3 = 0;
        while (n3 < n5) {
            if (n3 < n7 | n3 > n8) {
                n2 = n3;
                while (n2 < n5) {
                    this.V[n3][n2] = this.H[n3][n2];
                    ++n2;
                }
            }
            ++n3;
        }
        n2 = n5 - 1;
        while (n2 >= n7) {
            int n19 = n7;
            while (n19 <= n8) {
                d10 = 0.0;
                n = n7;
                while (n <= Math.min(n2, n8)) {
                    d10 += this.V[n19][n] * this.H[n][n2];
                    ++n;
                }
                this.V[n19][n2] = d10;
                ++n19;
            }
            --n2;
        }
    }

    private void orthes() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.n - 1;
        int n5 = n3 + 1;
        while (n5 <= n4 - 1) {
            double d = 0.0;
            n2 = n5;
            while (n2 <= n4) {
                d += Math.abs(this.H[n2][n5 - 1]);
                ++n2;
            }
            if (d != 0.0) {
                int n6;
                double d2 = 0.0;
                int n7 = n4;
                while (n7 >= n5) {
                    this.ort[n7] = this.H[n7][n5 - 1] / d;
                    d2 += this.ort[n7] * this.ort[n7];
                    --n7;
                }
                double d3 = Math.sqrt(d2);
                if (this.ort[n5] > 0.0) {
                    d3 = -d3;
                }
                d2 -= this.ort[n5] * d3;
                this.ort[n5] = this.ort[n5] - d3;
                int n8 = n5;
                while (n8 < this.n) {
                    double d4 = 0.0;
                    int n9 = n4;
                    while (n9 >= n5) {
                        d4 += this.ort[n9] * this.H[n9][n8];
                        --n9;
                    }
                    d4 /= d2;
                    n6 = n5;
                    while (n6 <= n4) {
                        double[] dArray = this.H[n6];
                        int n10 = n8;
                        dArray[n10] = dArray[n10] - d4 * this.ort[n6];
                        ++n6;
                    }
                    ++n8;
                }
                int n11 = 0;
                while (n11 <= n4) {
                    double d5 = 0.0;
                    n6 = n4;
                    while (n6 >= n5) {
                        d5 += this.ort[n6] * this.H[n11][n6];
                        --n6;
                    }
                    d5 /= d2;
                    int n12 = n5;
                    while (n12 <= n4) {
                        double[] dArray = this.H[n11];
                        int n13 = n12;
                        dArray[n13] = dArray[n13] - d5 * this.ort[n12];
                        ++n12;
                    }
                    ++n11;
                }
                this.ort[n5] = d * this.ort[n5];
                this.H[n5][n5 - 1] = d * d3;
            }
            ++n5;
        }
        int n14 = 0;
        while (n14 < this.n) {
            n = 0;
            while (n < this.n) {
                this.V[n14][n] = n14 == n ? 1.0 : 0.0;
                ++n;
            }
            ++n14;
        }
        n = n4 - 1;
        while (n >= n3 + 1) {
            if (this.H[n][n - 1] != 0.0) {
                n2 = n + 1;
                while (n2 <= n4) {
                    this.ort[n2] = this.H[n2][n - 1];
                    ++n2;
                }
                int n15 = n;
                while (n15 <= n4) {
                    double d = 0.0;
                    int n16 = n;
                    while (n16 <= n4) {
                        d += this.ort[n16] * this.V[n16][n15];
                        ++n16;
                    }
                    d = d / this.ort[n] / this.H[n][n - 1];
                    int n17 = n;
                    while (n17 <= n4) {
                        double[] dArray = this.V[n17];
                        int n18 = n15;
                        dArray[n18] = dArray[n18] + d * this.ort[n17];
                        ++n17;
                    }
                    ++n15;
                }
            }
            --n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("EigenvalueDecomposition(A) --> D, V, realEigenvalues, imagEigenvalues\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("realEigenvalues = ");
        try {
            stringBuffer.append(String.valueOf(this.getRealEigenvalues()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nimagEigenvalues = ");
        try {
            stringBuffer.append(String.valueOf(this.getImagEigenvalues()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nD = ");
        try {
            stringBuffer.append(String.valueOf(this.getD()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }

    private void tql2() {
        double d;
        int n;
        int n2;
        int n3 = 1;
        while (n3 < this.n) {
            this.e[n3 - 1] = this.e[n3];
            ++n3;
        }
        this.e[this.n - 1] = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Math.pow(2.0, -52.0);
        int n4 = 0;
        while (n4 < this.n) {
            d3 = Math.max(d3, Math.abs(this.d[n4]) + Math.abs(this.e[n4]));
            n2 = n4;
            while (n2 < this.n) {
                if (Math.abs(this.e[n2]) <= d4 * d3) break;
                ++n2;
            }
            if (n2 > n4) {
                n = 0;
                do {
                    double d5;
                    ++n;
                    d = this.d[n4];
                    double d6 = (this.d[n4 + 1] - d) / (2.0 * this.e[n4]);
                    double d7 = Algebra.hypot(d6, 1.0);
                    if (d6 < 0.0) {
                        d7 = -d7;
                    }
                    this.d[n4] = this.e[n4] / (d6 + d7);
                    this.d[n4 + 1] = this.e[n4] * (d6 + d7);
                    double d8 = this.d[n4 + 1];
                    double d9 = d - this.d[n4];
                    int n5 = n4 + 2;
                    while (n5 < this.n) {
                        int n6 = n5++;
                        this.d[n6] = this.d[n6] - d9;
                    }
                    d2 += d9;
                    d6 = this.d[n2];
                    double d10 = d5 = 1.0;
                    double d11 = d5;
                    double d12 = this.e[n4 + 1];
                    double d13 = 0.0;
                    double d14 = 0.0;
                    int n7 = n2 - 1;
                    while (n7 >= n4) {
                        d11 = d10;
                        d10 = d5;
                        d14 = d13;
                        d = d5 * this.e[n7];
                        d9 = d5 * d6;
                        d7 = Algebra.hypot(d6, this.e[n7]);
                        this.e[n7 + 1] = d13 * d7;
                        d13 = this.e[n7] / d7;
                        d5 = d6 / d7;
                        d6 = d5 * this.d[n7] - d13 * d;
                        this.d[n7 + 1] = d9 + d13 * (d5 * d + d13 * this.d[n7]);
                        int n8 = 0;
                        while (n8 < this.n) {
                            d9 = this.V[n8][n7 + 1];
                            this.V[n8][n7 + 1] = d13 * this.V[n8][n7] + d5 * d9;
                            this.V[n8][n7] = d5 * this.V[n8][n7] - d13 * d9;
                            ++n8;
                        }
                        --n7;
                    }
                    d6 = -d13 * d14 * d11 * d12 * this.e[n4] / d8;
                    this.e[n4] = d13 * d6;
                    this.d[n4] = d5 * d6;
                } while (Math.abs(this.e[n4]) > d4 * d3);
            }
            this.d[n4] = this.d[n4] + d2;
            this.e[n4] = 0.0;
            ++n4;
        }
        n2 = 0;
        while (n2 < this.n - 1) {
            n = n2;
            d = this.d[n2];
            int n9 = n2 + 1;
            while (n9 < this.n) {
                if (this.d[n9] < d) {
                    n = n9;
                    d = this.d[n9];
                }
                ++n9;
            }
            if (n != n2) {
                this.d[n] = this.d[n2];
                this.d[n2] = d;
                int n10 = 0;
                while (n10 < this.n) {
                    d = this.V[n10][n2];
                    this.V[n10][n2] = this.V[n10][n];
                    this.V[n10][n] = d;
                    ++n10;
                }
            }
            ++n2;
        }
    }

    private void tred2() {
        int n;
        int n2 = 0;
        while (n2 < this.n) {
            this.d[n2] = this.V[this.n - 1][n2];
            ++n2;
        }
        int n3 = this.n - 1;
        while (n3 > 0) {
            int n4;
            double d = 0.0;
            double d2 = 0.0;
            n = 0;
            while (n < n3) {
                d += Math.abs(this.d[n]);
                ++n;
            }
            if (d == 0.0) {
                this.e[n3] = this.d[n3 - 1];
                n4 = 0;
                while (n4 < n3) {
                    this.d[n4] = this.V[n3 - 1][n4];
                    this.V[n3][n4] = 0.0;
                    this.V[n4][n3] = 0.0;
                    ++n4;
                }
            } else {
                int n5;
                n4 = 0;
                while (n4 < n3) {
                    int n6 = n4;
                    this.d[n6] = this.d[n6] / d;
                    d2 += this.d[n4] * this.d[n4];
                    ++n4;
                }
                double d3 = this.d[n3 - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                this.e[n3] = d * d4;
                d2 -= d3 * d4;
                this.d[n3 - 1] = d3 - d4;
                int n7 = 0;
                while (n7 < n3) {
                    this.e[n7] = 0.0;
                    ++n7;
                }
                int n8 = 0;
                while (n8 < n3) {
                    this.V[n8][n3] = d3 = this.d[n8];
                    d4 = this.e[n8] + this.V[n8][n8] * d3;
                    n5 = n8 + 1;
                    while (n5 <= n3 - 1) {
                        d4 += this.V[n5][n8] * this.d[n5];
                        int n9 = n5;
                        this.e[n9] = this.e[n9] + this.V[n5][n8] * d3;
                        ++n5;
                    }
                    this.e[n8] = d4;
                    ++n8;
                }
                d3 = 0.0;
                n5 = 0;
                while (n5 < n3) {
                    int n10 = n5;
                    this.e[n10] = this.e[n10] / d2;
                    d3 += this.e[n5] * this.d[n5];
                    ++n5;
                }
                double d5 = d3 / (d2 + d2);
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = n11;
                    this.e[n12] = this.e[n12] - d5 * this.d[n11];
                    ++n11;
                }
                int n13 = 0;
                while (n13 < n3) {
                    d3 = this.d[n13];
                    d4 = this.e[n13];
                    int n14 = n13;
                    while (n14 <= n3 - 1) {
                        double[] dArray = this.V[n14];
                        int n15 = n13;
                        dArray[n15] = dArray[n15] - (d3 * this.e[n14] + d4 * this.d[n14]);
                        ++n14;
                    }
                    this.d[n13] = this.V[n3 - 1][n13];
                    this.V[n3][n13] = 0.0;
                    ++n13;
                }
            }
            this.d[n3] = d2;
            --n3;
        }
        int n16 = 0;
        while (n16 < this.n - 1) {
            int n17;
            this.V[this.n - 1][n16] = this.V[n16][n16];
            this.V[n16][n16] = 1.0;
            double d = this.d[n16 + 1];
            if (d != 0.0) {
                n17 = 0;
                while (n17 <= n16) {
                    this.d[n17] = this.V[n17][n16 + 1] / d;
                    ++n17;
                }
                n = 0;
                while (n <= n16) {
                    double d6 = 0.0;
                    int n18 = 0;
                    while (n18 <= n16) {
                        d6 += this.V[n18][n16 + 1] * this.V[n18][n];
                        ++n18;
                    }
                    int n19 = 0;
                    while (n19 <= n16) {
                        double[] dArray = this.V[n19];
                        int n20 = n;
                        dArray[n20] = dArray[n20] - d6 * this.d[n19];
                        ++n19;
                    }
                    ++n;
                }
            }
            n17 = 0;
            while (n17 <= n16) {
                this.V[n17][n16 + 1] = 0.0;
                ++n17;
            }
            ++n16;
        }
        int n21 = 0;
        while (n21 < this.n) {
            this.d[n21] = this.V[this.n - 1][n21];
            this.V[this.n - 1][n21] = 0.0;
            ++n21;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }
}

